/*
 * Decompiled with CFR 0.152.
 */
class Vector4 {
    float x;
    float y;
    float z;
    float w;

    Vector4() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    Vector4(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    Vector4(Vector4 vector4) {
        this.x = vector4.x;
        this.y = vector4.y;
        this.z = vector4.z;
        this.w = vector4.w;
    }

    void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    Vector4 copy() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    void add(Vector4 vector4) {
        this.x += vector4.x;
        this.y += vector4.y;
        this.z += vector4.z;
        this.w += vector4.w;
    }

    void sub(Vector4 vector4) {
        this.x -= vector4.x;
        this.y -= vector4.y;
        this.z -= vector4.z;
        this.w *= vector4.w;
    }

    void mul(Vector4 vector4) {
        this.x *= vector4.x;
        this.y *= vector4.y;
        this.z *= vector4.z;
        this.w *= vector4.w;
    }

    void div(Vector4 vector4) {
        this.x /= vector4.x;
        this.y /= vector4.y;
        this.z /= vector4.z;
        this.w /= vector4.w;
    }

    void mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
    }

    void div(float f) {
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }

    float dot(Vector4 vector4) {
        return this.x * vector4.x + this.y * vector4.y + this.z * vector4.z + this.w * vector4.w;
    }

    public Vector3 cross(Vector4 vector4) {
        float f = this.y * vector4.z - vector4.y * this.z;
        float f2 = this.z * vector4.x - vector4.z * this.x;
        float f3 = this.x * vector4.y - vector4.x * this.y;
        return new Vector3(f, f2, f3);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        float f = this.length();
        if (f > 0.0f) {
            this.div(f);
        }
    }

    Vector4 lerp(Vector4 vector4, float f) {
        return new Vector4(this.x + f * (vector4.x - this.x), this.y + f * (vector4.y - this.y), this.z + f * (vector4.z - this.z), this.w + f * (vector4.w - this.w));
    }

    boolean SetBaryCentric(Vector4 vector4, Vector4 vector42, Vector4 vector43, float f, float f2) {
        this.x = vector4.x + f * (vector42.x - vector4.x) + f2 * (vector43.x - vector4.x);
        this.y = vector4.y + f * (vector42.y - vector4.y) + f2 * (vector43.y - vector4.y);
        this.z = vector4.z + f * (vector42.z - vector4.z) + f2 * (vector43.z - vector4.z);
        return true;
    }

    Vector4 transform(Matrix matrix) {
        float f = this.x * matrix._M[0] + this.y * matrix._M[4] + this.z * matrix._M[8] + matrix._M[12];
        float f2 = this.x * matrix._M[1] + this.y * matrix._M[5] + this.z * matrix._M[9] + matrix._M[13];
        float f3 = this.x * matrix._M[2] + this.y * matrix._M[6] + this.z * matrix._M[10] + matrix._M[14];
        float f4 = 0.0f;
        return new Vector4(f, f2, f3, f4);
    }

    public static Vector4 add(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x + vector42.x, vector4.y + vector42.y, vector4.z + vector42.z, vector4.w + vector42.w);
    }

    public static Vector4 sub(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x - vector42.x, vector4.y - vector42.y, vector4.z - vector42.z, vector4.w - vector42.w);
    }

    public static Vector4 mul(Vector4 vector4, Vector4 vector42) {
        return new Vector4(vector4.x * vector42.x, vector4.y * vector42.y, vector4.z * vector42.z, vector4.w * vector42.w);
    }

    public static Vector3 cross(Vector3 vector3, Vector3 vector32) {
        float f = vector3.y * vector32.z - vector32.y * vector3.z;
        float f2 = vector3.z * vector32.x - vector32.z * vector3.x;
        float f3 = vector3.x * vector32.y - vector32.x * vector3.y;
        return new Vector3(f, f2, f3);
    }

    public static float distance(Vector4 vector4, Vector4 vector42) {
        float f = vector4.x - vector42.x;
        float f2 = vector4.y - vector42.y;
        float f3 = vector4.z - vector42.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float angleBetween(Vector4 vector4, Vector4 vector42) {
        float f = vector4.dot(vector42);
        float f2 = (float)Math.acos(f / (vector4.length() * vector42.length()));
        return f2;
    }
}

