//-------------------------------------------------------------------
// ovVF[_[ for MQO
//-------------------------------------------------------------------
//-------------------------------------------------------------------
// O[op[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;
float4 shDiffuse;
float3 shAmbient;
float3 shEyePos;

float3 shLightColor;
float3 shLightPos;

float3 shKe;	// emission
float3 shKa;	// ambient
float3 shKd;	// diffuse
float3 shKs;	// specular
float  shShininess;

float  shRate : TIME_RATE;

//-------------------------------------------------------------------
// MQOp[^
//-------------------------------------------------------------------
// J[
float4 shMqoColor;

// eNX`[ ͗l ]
sampler2D shBaseTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};
// eNX`[  ]
sampler2D shOverlapTexture = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

sampler2D shima = sampler_state {
  minFilter = Linear;
  magFilter = Linear;
};

#define NO_LIGHTING_DEBUG (1)// CeBO𖳌ɂ

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void defaultVS(float4 in_pos 			: POSITION,
				float3 in_norm   		: NORMAL,
				float3 in_col 			: COLOR0,
				float2 in_texcoord 		: TEXCOORD0,
				out float4 out_pos 		: POSITION,
				out float4 out_col		: COLOR0,
				out float2 out_texcoord : TEXCOORD0,
				out float3 out_tan		: TEXCOORD1,
				out float3 out_E        : TEXCOORD2,
				out float3 out_L		: TEXCOORD3,
				out float3 out_N		: TEXCOORD4
				)
{
	//pos
	out_pos = mul(shVProjMat, in_pos);
	float3 wpos = mul(shViewMat, mul(shWorldMat, in_pos));
	out_N = mul((float3x3)shViewMat, mul((float3x3)shWorldMat, in_norm));
	
	float3 YVec  = {0.01f,1.0f,0.01f};//Y dir vector
	//calc tangent vector(fake)
	float3 B = normalize(cross(in_norm,YVec));
	float3 T = normalize(cross(B,in_norm));
	B = normalize(cross(in_norm,T));
	
	// use tangent
	//float3 T = in_col;
	//float3 B = normalize(cross(in_norm,T));
	
	//translate tangent vector
	float3 E = normalize((wpos - shEyePos).xyz);
	out_E.x = dot(E,T);
	out_E.y = dot(E,B);
	out_E.z = dot(E,in_norm);
	float3 L = normalize(float3(0.3f, 0.6f, 1.0f));
	out_L.x = dot(L,T);
	out_L.y = dot(L,B);
	out_L.z = dot(L,in_norm);
	
	out_col = shMqoColor;
	out_tan = in_col;
	//texcoord
	out_texcoord = in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void defaultPS(float4 in_col : COLOR0,
			float2 samplePos : TEXCOORD0,
			float3 in_tan : TEXCOORD1,
			float3 in_E   : TEXCOORD2,
			float3 in_L	  : TEXCOORD3,
			float3 in_N   : TEXCOORD4,
			out float4 out_col : COLOR
			)
{
	// color
	//out_col = tex2D(shBaseTexture, samplePos) * in_col;
	//out_col = float4(in_tan,1);
	//out_col = max(0, dot(normalize(tex2D(shBaseTexture, samplePos*16) - 0.5f), in_L));
	float3 bp = normalize(tex2D(shOverlapTexture, samplePos*16).rgb - 0.5f) * (0.2f * tex2D(shima, in_N) + 0.8f);
	float sp = max(0, dot( reflect(in_E, bp), in_L));
	float dr = max(0, dot( bp, in_L));
	out_col = (pow(sp,5.0f)*2.0f + dr*0.6f + 0.2f) * tex2D(shBaseTexture, samplePos) * in_col;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		//AlphaBlendEnable = true;
		//BlendFunc = int2(SrcAlpha, OneMinusSrcAlpha);

		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf defaultPS();
	}
}
