//-------------------------------------------------------------------
//
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------

// ˉes
float4x4	projMat;
float		blendRate;


// eNX`Tv

// V[CO@J[obt@
sampler2D srcCBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@J[obt@
sampler2D srcCBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CO@Zobt@
sampler2D srcZBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@Zobt@
sampler2D srcZBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CO@[Nobt@
sampler2D workBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};
// V[CP@[Nobt@
sampler2D workBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

float shTime0 : TIME_RATE_0;// V[C0̎
float shTime1 : TIME_RATE_1;// V[C1̎
float shTimeEffect : TIME_RATE_EFFECT;// ̃GtFNg̎


//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void radialBlurVS(	float4 in_pos			: POSITION	,
				float2 in_texcoord		: TEXCOORD0	,
				out float4 out_pos		: POSITION	,
				out float2 out_texcoord	: TEXCOORD0 )
{
	// pos
	out_pos = mul( projMat, in_pos );

	// texcoord
	out_texcoord = in_texcoord;
}

#define SAMPLE_NUM 16
#define BLUR_START 1.0f
#define BLUR_WIDTH 0.2f
//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void radialBlurPS(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	float BlurWidth;
	if( shTimeEffect<0.5f ){
		BlurWidth = BLUR_WIDTH*(shTimeEffect*2.f);
	}else{
		BlurWidth = BLUR_WIDTH*(1.f-(shTimeEffect-0.5f)*2.0f);
	}

	float4 tmpColor = float4(0,0,0,0);
	float2 Center = float2(0.5f,0.5f);
	samplePos -= Center;
	for(int i=0; i<SAMPLE_NUM; i++) {
		float scale = BLUR_START - BlurWidth*(i/(((float)SAMPLE_NUM)-1.0f));
		float4 texColor = tex2D(srcCBuf0, samplePos*scale + Center );
		texColor /= (float)SAMPLE_NUM;
		tmpColor += texColor;
	}
	out_col = tmpColor;
}
void copyAsIsPS(float4 in_col		: COLOR		,
			 float2 samplePos	: TEXCOORD0	,
			 out float4 out_col	: COLOR		)
{
	out_col = tex2D(workBuf0, samplePos);
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv radialBlurVS();
		FragmentProgram = compile glslf radialBlurPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	pass P1
	{
		VertexProgram   = compile glslv radialBlurVS();
		FragmentProgram = compile glslf copyAsIsPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}
