--
dofile "data:runtime.lua"

-------------------------------------------------------------------------------
--	utils
-------------------------------------------------------------------------------

function startdmascreen()
	call(-2, do_flipscreen, -1)
	call(-1, do_clearscreen, -1)
	call(5, do_render, -1)
end

function stopdmascreen()
	kill(-2,-1,5)		-- stop flip, clear, render
	do_flipscreen()	-- enforce last dma commit
end

function runpart(dur, part)
	pushtime()
	part()
	waitabs(dur)
	kill(0,1,2,3)
	poptime()
end

function interp_cosn(n, ...)
	local step = 0
	return function()
		local c = (cos(pi * step / (n - 1) - pi) * 0.5) + 0.5
		local t = { }
		local j = 1
		for i = 1, #arg / 2 do
			t[i] = c * (arg[j+1] - arg[j]) + arg[j]
			j = j + 2
		end
		if step < n then
			step = step + 1
		end
		return unpack(t)
	end
end

function interp_cos(n, a, b)
	local step = 0
	return function()
		local c = (cos(pi * step / (n - 1) - pi) * 0.5) + 0.5
		local t = { }
		local j = 1
		if step < n then
			step = step + 1
		end
		return c * (b - a) + a
	end
end

function interp_sin(n, a, b)
	local step = 0
	return function()
		local c = (sin(pi * step / (n - 1) - pi) * 0.5) + 0.5
		local t = { }
		local j = 1
		if step < n then
			step = step + 1
		end
		return c * (b - a) + a
	end
end

function interp_lin(n, ...)
	local step = 0
	return function()
		local c = step / (n - 1)
		local t = { }
		local j = 1
		for i = 1, #arg / 2 do
			t[i] = c * (arg[j+1] - arg[j]) + arg[j]
			j = j + 2
		end
		if step < n then
			step = step + 1
		end
		return unpack(t)
	end
end

-- provide rhythm as off-peak sawtooth (peaks at clap):

function getclap()
	return 1 - ((rt.absframe - 20) % 60) / 60
end

-- provide rhythm as amplitude/frequency modulated sine:

function getclap2()
	local c = getclap()
	c = c * 1.4
	c = c * c * c * c
 	return sin(c * pi * 2 - pi) * c
end

function showclaps()
	call(4, function(f)
		if f % 60 == 20 then
			do_setclearcolor(1,1,1,0)
		else
			do_setclearcolor(0,0,0,0)
		end
		end, -1)
end

-------------------------------------------------------------------------------
-- parts
-------------------------------------------------------------------------------

function init_land_part()
	return queue(init_newland)
end

function part_land()

	runpart(2200, function()
		kill(5)

 		set_land(1)
 		do_setclearcolor(0,0,0,0)

		local ipf1_in = interp_cos(50, 512, -384)
		local ipf2_in = interp_cos(50, -384, 0)

		local ipf_out = interp_cos(50, 0, 512)

		local ipf_fogout = interp_cos(170, 0.002185, -0.000019)
		local ipf_fogcolr = interp_cos(50, 0.729412, 0.694118)
		local ipf_fogcolg = interp_cos(50, 0.831373, 0.800000)
		local ipf_fogcolb = interp_cos(50, 1.000000, 1.000000)

		local ipf_cur = ipf1_in

		call(0, function(f)

			if f > 50 then
				ipf_cur = ipf2_in
			end


			if f <= 100 then
				land_back(0, ipf_cur(), 640, 512, 0.694118, 0.800000, 1.000000)
			end

			if f == 100 then
				do_setclearcolor(0.694118, 0.800000, 1.000000)
			end


			if f > 1990 then
				-- fade out
				land_fogcol(ipf_fogcolr(), ipf_fogcolg(), ipf_fogcolb())
				land_fog(ipf_fogout())

				if f > 2150 then
					land_back(0, ipf_out(), 640, 512, 0.694118, 0.800000, 1.000000)
					do_setclearcolor(0,0,0,0)
				end
			end

			do_newland(f, (f >= 100), false, false) -- vergiss mich nicht!
		end, -1)
	end)
	call(5, do_render, -1)
	exit_newland()
end

function endpart_land()

	runpart(-1, function()
		kill(5)

 		set_land(0)

		call(0, function(f)

			if f < 100 then
				do_setclearcolor(0,0,0,0)
			elseif f == 100 then
				do_setclearcolor(0.462745,0.478431,0.635294)
			end

			do_newland(f, (f >= 100), false, true)
				do_texton(0, 1)
				do_text()
		end, -1)
	end)
	call(5, do_render, -1)
	exit_newland()
end

-------------------------------------------------------------------------------

function init_credits_part()
	queue(init_bubbles, 1)
	queue(init_text)
	queue(init_vtextslot, 0, "... credits ...",                     13, 2, -15,-14,0, 0.00)
	queue(init_vtextslot, 1, "code and design by blue",             19, 4, -15,-12,0, 0.00)
	queue(init_vtextslot, 2, "music by banana",                     13, 2, -15,-10,0, 0.00)
	queue(init_vtextslot, 3, "... special thanks ...",              19, 3, -15, -6,0, 0.00)
	queue(init_vtextslot, 4, "bifat - trigonometric incantations",  31, 3, -15, -4,0, 0.00)
	return queue(init_vtextslot, 5, "gawd - mcount implementation", 25, 3, -15, -2,0, 0.00)
	--queue(init_vtextslot, 6, "d136b - released at the",             19, 4, -15,  0,0, 0.00)
	--return queue(init_vtextslot, 7, "oxyron party v2",              13, 2, -15,  2,0, 0.00)
end

function part_credits()

	runpart(1400, function()
		local ipf_camz = interp_cos(700, -260, -60)
		local ipf_textin = interp_cos(350, 0, 0.5)
		local ipf_textout = interp_cos(250, 0.5, 0)

		do_setclearcolor(0,0,0,0.5)
 		wait(1)

		call(0, function(f)

				do_bubbles(f, false)

				if f > 300 then

					bubble_pos(0, 1.254160, ipf_camz())

					if f < 600 then
						local fi = ipf_textin()
						do_textefx(0, fi)
						do_textefx(1, fi)
						do_textefx(2, fi)
						do_textefx(3, fi)
						do_textefx(4, fi)
						do_textefx(5, fi)

						do_texton(0, 1)
						do_texton(1, 1)
						do_texton(2, 1)
						do_texton(3, 1)
						do_texton(4, 1)
						do_texton(5, 1)

					elseif f > 1150 then
						local fo = ipf_textout()
						do_textefx(0, fo)
						do_textefx(1, fo)
						do_textefx(2, fo)
						do_textefx(3, fo)
						do_textefx(4, fo)
						do_textefx(5, fo)
					end
					do_text()

					-- bubble_epf(170)

					if f == 1300 then
						bubble_epf(0)
					end
				end

			end, -1)

	end)
 	exit_bubbles()
 	exit_text()
end

-------------------------------------------------------------------------------

function init_title_part()
	queue(init_text)
	-- slot, text, numc, numl, x, y, z, speed
	queue(init_vtextslot, 0, "d136b",          5, 4,  2.5, 1.0, -9, 0)
	queue(init_vtextslot, 1, "a \^ demo by",   8, 3,  0.0, 5.0,  0, 0)
	queue(init_vtextslot, 2, "neoscientists", 13, 0,  2.5, 7.0,  0, 0)
	return queue(init_bubbles, 0)
end

function part_title()

	runpart(1500, function()

		do_setclearcolor(0,0,0,0.5)
 		wait(1)

 		local ipf1 = interp_cos(300, 1, 27)
		local ipf1_textin = interp_cos(150, 0, 0.5)
		local ipf1_textout = interp_cos(100, 0.5, 0)

		local ipf2_textin = interp_cos(150, 0, 0.5)
		local ipf2_textout = interp_cos(50, 0.5, 0)

		local ipf_epf  = interp_cos(100, 27, 337)
		local ipf_rotx = interp_cos(100, 4.150315, 3.569522)
		local ipf_rotz = interp_cos(100, 5.905029, 0)
		local ipf_evar = interp_cos(100, 0, 11)

		local sync = true

		call(0, function(f)
				do_bubbles(f, sync)

				if f > 20 and f < 150 then
					bubble_epf(1)
				end

				if f >= 150 and f < 950 then

					if f < 450 then
						bubble_epf(ipf1())
						-- fade in and readme
						do_textefx(0, ipf1_textin()) -- 150 frames
						do_texton(0, 1)
						do_text()
					elseif f >= 450 and f < 550 then
						-- fade out
						do_textefx(0, ipf1_textout()) -- 100 frames
						do_texton(0, 1)
						do_text()
					elseif f >= 550 and f < 800 then
						-- fade in and readme
						local ipf = ipf2_textin()
						if f < 700 then
						do_textefx(1, ipf) -- 150 frames
						do_textefx(2, ipf) -- 150 frames
						end
						do_texton(1, 1)
						do_texton(2, 1)
						do_text()
 					elseif f >= 800  and f < 850 then
 						-- fade out
 						local ipf = ipf2_textout()
						do_textefx(1, ipf) -- 50 frames
						do_textefx(2, ipf) -- 50 frames
						do_texton(1, 1)
						do_texton(2, 1)
 						do_text()
 					end
				end

				if f >= 950 and f < 1050 then
					sync = false
					bubble_rot(ipf_rotx(), 0, ipf_rotz())
					bubble_epf(ipf_epf())
					bubble_evar(ipf_evar())
				end

				if f == 1350 then
					bubble_epf(0)

				end

				if f == 1400 then
					bubble_evar(0)
				end

			end, -1)

	end)
	exit_bubbles()
 	exit_text()
end

-------------------------------------------------------------------------------

function init_greetings_part()
	y = 0
	queue(init_text)
	queue(init_qtunnel)
	return queue(init_greetings,
	 "greetings... soopadoopa k2 tek oxyron fan rabenauge wamma & PwP smash designs farbrausch          "
	)
end

function init_qtunnel_part()
	return queue(init_qtunnel)
end

function part_greetings()

	runpart(1865+100+5, function()

		--local ipf_camroty0 = interp_cos(40, 0.18, 0.28)
		local ipf_camroty1 = interp_cos(40, 0.28, 1.5)
		local ipf_camroty2 = interp_cos(40, 1.5, -0.4)
		local ipf_camroty3 = interp_cos(40, -0.4, 0.28)

		local ipf_camrotz = interp_cos(60, 0, pi*2)
		local ipf_out = interp_cos(50, -512, 0)

-- 		local sx, sy, sz = 0, 0, 0

		call(1, function(f)
			do_qtunnel(f)

-- 			sx = sx + 0.011 if sx >= 2 * pi then sx = sx - 2 * pi end
-- 			sy = sy + 0.007 if sy >= 2 * pi then sy = sy - 2 * pi end
-- 			sz = sz + 0.008 if sz >= 2 * pi then sz = sz - 2 * pi end
-- 			qtunnel_campos(sin(sx) * 0.3, sin(sy) * 0.03, sin(sz) * 0.03)

			if f < 200 then
				qtunnel_door(0,0,0)
			end

 			if f > 150 then
 				-- qtunnel_camroty(ipf_camroty0())
 				do_greetings()
 			end

  			if f > 760 and f < 820 then
 				qtunnel_camrotz(ipf_camrotz())
  			end

			if f > 1600 then
				if f < 1740 then
					qtunnel_camroty(ipf_camroty1())
				end

				if f > 1660 and f < 1700 then
					qtunnel_camroty(ipf_camroty2())
				end

				if f >= 1700 and f < 1740 then
					qtunnel_camroty(ipf_camroty3())
				end

				if f >= 1965 - 50 then
					qtunnel_frect(0, ipf_out(), 640, 512, 0, 0, 0)
				end
			end

		end, -1)
	end)
	exit_qtunnel()
	exit_text()
end

function part_qtunnel()

	runpart(500, function()
		call(1, function(f)
			do_qtunnel(f)
		end, -1)
	end)
	exit_qtunnel()
end


-------------------------------------------------------------------------------

function init_canvas_part()
	return queue(init_canvas)
end

function part_canvas()

	 runpart(2300, function()
		local i = 1

		local xdv =    {   80,    40,   32,   16,    8,    4,    2,    1 }
		local ydv =    {  100,    50,   40,   20,   10,    5,    2,    1 }
		local campos = { -260,  -240, -220, -200, -175, -160, -125, -105 }
		local time =   {  900,  1100, 1135, 1275, 1380, 1475, 1515, 1550 }

		local ipf1_move = interp_cos(100, 0.5, 1)
		local ipf1_lightint = interp_cos(900, 0, 12)

		local ipf_amp = interp_cos(150, 0.5625, 1)
		local ipf_campos = interp_cos(150, -105, 1)
		local ipf2_lightint = interp_cos(300, 12, 17)

		local ipf1_roty = interp_cos(1, 0, 0.201888)
		local ipf1_rotz = interp_cos(1, 0, 1.854866)
		local ipf2_rotx = interp_cos(15, 0, 0.362828)
		local ipf2_rotz = interp_cos(15, 1.854866, 2.618210)
		local ipf3_rotx = interp_cos(20, 0.362828, 0.142517)
		local ipf3_rotz = interp_cos(20, 2.618210, 3.761304)

		local ipf_camout = interp_lin(150, 1, -190)
		local ipf_lightout = interp_cos(50, 16.999443, 0)

--		play_music(0)

		call(1, function(f)

--			if f == 65 then play_music(1) end

			if f < 900 then
				-- show 2d plasma
				canvas_movelight(true, 80, 800)
				canvas_lightint(ipf1_lightint())
				do_canvas(f, 0, false)

			elseif f >= 900 and f <= 1551 then

				canvas_div(xdv[i], ydv[i])
				canvas_campos(0, 0, campos[i])
				do_canvas(f, (i+1)/11)

-- 				blitz(f-time[i])

				if time[i+1] == f then
  					i = i + 1
  				end
			else

				do_canvas(f, ipf_amp())
				canvas_movelight(true, 5, 50)
				canvas_lightint(ipf2_lightint())	-- 300
				canvas_campos(0, 0, ipf_campos())	-- 150

 				if f == 1580 then
 					-- do_setclearcolor(0,0,0,0)
 				end

 				if f == 1770 then
 					canvas_scenerot(0,ipf1_roty(),ipf1_rotz())
 				end

				if f >= 1960 and f < 2150 then
					canvas_scenerot(ipf2_rotx(), 0, ipf2_rotz())
				end

 				if f >= 2150 then
 					canvas_campos(0, 0, ipf_camout())
 					canvas_scenerot(ipf3_rotx(), 0, ipf3_rotz())
 				end

 				if f >= 2250 then
 					canvas_lightint(ipf_lightout())
 				end

 			end
		end, -1)
	end)
	exit_canvas()
end

-------------------------------------------------------------------------------

function init_scroller()
	queue(init_text)

	return queue(init_htextslot, 0, [[
... you have reached the end of d136b, a contribution to the oxyron party v2,
held in flensburg/germany. hit triangle button to activate the menu system of
this part. use shoulder buttons to cycle through the menu screens. start resets
the current parameter. select dumps the current parameter set to stdout. use x
button to freeze the screen. note that the clipping code is still not fully
generic so beware of those nasty clipping bugs :)




























]], 70,10, 2,8,-8, 0.1)

end

-------------------------------------------------------------------------------
--	main
-------------------------------------------------------------------------------

--	avail("script entered")

	do_setclearcolor(0,0,0,0)
	startdmascreen()

	play_music(1)
	wait(1)
	resettime()
--	showclaps()

--- --- - -  -   -

	ititle = init_title_part()
	sync(ititle)
	iland = init_land_part()
	part_title()

	sync(iland)
	part_land()
	iland = false

	igreet = init_greetings_part()
 	sync(igreet)
	icanvas = init_canvas_part()
	part_greetings()

	sync(icanvas)
	part_canvas()

	icredits = init_credits_part()
	sync(icredits)
	iland = init_land_part()
	part_credits()

	iscroller = init_scroller()
	sync(iscroller)
	sync(iland)
	endpart_land()

--- --- - -  -   -

	wait(-1)
