#!/usr/bin/perl

#use warnings;
use strict;

use lib '../include';

use nms qw(switch_connect switch_exec switch_disconnect);

use Net::Telnet::Cisco;
use Net::Ping;

use Term::ANSIColor;

$| = 1;

BEGIN {
	require "../include/config.pm";
	eval {
		require "../include/config.local.pm";
	};
}

my $ios = Net::Telnet::Cisco->new(
			Host => $nms::config::telegw_ip,
			Errmode => 'return',
                        Prompt => '/\S+[#>]/');
if (!defined($ios)) {
	print STDERR colored('ERROR', 'red'), 
			": Could not connect to $nms::config::telegw_ip\n";    
}	
$ios->login($nms::config::ios_user, $nms::config::ios_pass);
$ios->enable;
#$ios->cmd("terminal length 0"); 
my $inval = 0;
my $outval = 0;
my $output = join("\n", $ios->cmd("show interface gig 1/1"));
foreach my $interface ( @nms::config::telegw_wanlinks ) {
	my $output = join("\n", $ios->cmd("show interface " . $interface));
	$output =~  m/.* packets input, (\d+) bytes.*/;
	$inval += $1;
	$output =~  m/.* packets output, (\d+) bytes.*/;
	$outval += $1;
}
my $in_recalc = $inval / (1024*1024*1024*1024);
my $out_recalc = $outval / (1024*1024*1024*1024);

print "Total inbound traffic   : ", colored($in_recalc . " TiB ( ". $inval . " bytes)", 'green'), "\n";
print "Total outbound traffic  : ", colored($out_recalc . " TiB ( ". $outval . " bytes)", 'red'), "\n";

$ios->close;

