#! /usr/bin/perl -w
use strict;

my $date = `date --rfc-2822`;
chomp $date;

my @nets = ();
open NAMES, "switches.txt"
	or die "switches.txt: $!";
while (<NAMES>) {
	chomp;
	/87\.76\.(\d+\.\d+)\s+(\d+)\s+(\S+)(?:\s+(\S+))?/ or next;
	
	my $mgmt = $4;

	push @nets, {
		net => $1,
		netmask => $2,
		name => $3,
		management => $mgmt
	};
}	

my %portmap = ();
open PATCHLIST, "patchlist.txt"
	or die "patchlist.txt: $!";
while (<PATCHLIST>) {
	chomp;
	my ($name, $switch, $port) = split / /, $_;
	$port =~ s,g1/1,17,g;
	$port =~ s,g1/2,18,g;
	$port =~ s,g1/3,19,g;
	$port =~ s,g1/4,20,g;
	$port =~ s,g1/5,21,g;
	$port =~ s,g1/6,22,g;
	$port =~ s,g2/4,36,g;
	$port =~ s,g2/5,37,g;
	$port =~ s,g2/8,40,g;
	$port =~ s,g2/9,41,g;
	$portmap{$name} = $port;
}	

print <<"EOF";
# Autogenerated by make-dhcpd.pl at $date. Do not edit manually!

option domain-name "tg09.gathering.org";
option domain-name-servers 87.76.254.2, 87.76.255.2;

# Netboot FTW
next-server 87.76.255.24;
filename "/pxelinux.0";

ddns-update-style interim;
omapi-port 7911;

# dnssec-keygen -a HMAC-MD5 -b 128 -n HOST DHCP_UPDATER
key DHCP_UPDATER {
	algorithm HMAC-MD5.SIG-ALG.REG.INT;
	secret seGDD1r9u8iEAnEAetd9fg==;
}

default-lease-time 14400;
max-lease-time 28800;

# Tele-nett
subnet 87.76.254.0 netmask 255.255.255.0 {
}

# Server-nett
subnet 87.76.255.0 netmask 255.255.255.0 {
	range 87.76.255.240 87.76.255.254;
	option routers 87.76.255.1;
	next-server 87.76.255.24;
	filename "pxelinux.0";
}

# diger wlan-range til ior
zone 148.76.87.in-addr.arpa. { primary 127.0.0.1; key DHCP_UPDATER; }
zone 149.76.87.in-addr.arpa. { primary 127.0.0.1; key DHCP_UPDATER; }
zone 150.76.87.in-addr.arpa. { primary 127.0.0.1; key DHCP_UPDATER; }
zone 151.76.87.in-addr.arpa. { primary 127.0.0.1; key DHCP_UPDATER; }
zone public-wlan.tg09.gathering.org. {
   primary 127.0.0.1;
   key DHCP_UPDATER;
}
subnet 87.76.148.0 netmask 255.255.252.0 {
	authoritative;
	option routers 87.76.148.1;

	range 87.76.148.10 87.76.150.9;
	range 87.76.150.12 87.76.151.254;
	option domain-name "public-wlan.tg09.gathering.org";
	ddns-domainname "public-wlan.tg09.gathering.org";
	ignore client-updates;
}

EOF

# Generering av DNS update zone stash ut fra switches.txt ...
# Grunnen til mekkingen her er at DNS sonene bør være classful
# for å ikke introdusere for mye komplexitet.
my @nets_done;
for my $net (@nets) {
	my $domain = $net->{name};

	# Vi vil kun bruke /24 oktetten, rett og slett fordi reverse
	# sonefiler i named er /24 class. I $net ligger de siste to oktetter..
	my $thisnet = $net->{'net'};
	$thisnet =~ s/\.\d+$//;

	# Vi dytter kun en definisjon hvis vi ikke allerede har sett dette tallet.
	# Dette gir svakheten at vi ikke kan regne med å se /23 eller større nett,
	# men slike nett har vi kun unntaksvis ^_^
   # For eksempel på håndtering av det, gjør /diger wlan-range til ior/
	if ( not grep ( $_ == $thisnet, @nets_done ) ) {
		push @nets_done, $thisnet;
		my $zone = "$thisnet.76.87.in-addr.arpa.";
		print "zone $zone { primary 127.0.0.1; key DHCP_UPDATER; }\n";
	}
}

for my $net (@nets) {
	my $domain = $net->{name};

	# Hihi. Magisk range for ting som skal inn i dns, men er hardkodet i dhcp.
   # Typisk nyttig for jalla-rangene til ior-wlanet.
	next if $net->{'net'} eq "127.0.0.0";

	my ($netmask, $numpc, $start, $end);
	$start = 10;

	if ($net->{netmask} == 24) {
		$netmask = "255.255.255.0";
		$numpc = 256;
	} elsif ($net->{netmask} == 25) {
		$netmask = "255.255.255.128";
		$numpc = 128;
	} elsif ($net->{netmask} == 26) {
		$netmask = "255.255.255.192";
		$numpc = 64;
	} elsif ($net->{netmask} == 30) {
		$netmask = "255.255.255.252";
		$numpc = 4;
		$start = 2;
	} else {
		die "Unknown netmask /" . $net->{netmask};
	}

	$net->{net} =~ /(\d+)\.(\d+)/ or die "Unknown net $net";
	my ($majorsubnet,$minorsubnet) = ($1,$2);

	# FIXME: Should use Net::CIDR
	my $gw = "87.76.$majorsubnet." . ($minorsubnet + 1);
	my $rangestart = "87.76.$majorsubnet." . ($minorsubnet + $start);
	my $rangeend = "87.76.$majorsubnet." . ($minorsubnet + $numpc - 2);

	print <<"EOF";
zone $domain.tg09.gathering.org. {
	primary 127.0.0.1;
	key DHCP_UPDATER;
}
subnet 87.76.$net->{net} netmask $netmask {
	authoritative;
	option routers $gw;

	range $rangestart $rangeend;
	option domain-name "$domain.tg09.gathering.org";
	ddns-domainname "$domain.tg09.gathering.org";
	ignore client-updates;
EOF

	if ($domain eq 'noc') {
		print <<"EOF";
	# Steinars boks
	host trofast {
		hardware ethernet 00:0e:0c:36:a7:66;
		fixed-address 87.76.250.100;

		next-server 87.76.254.26;
		filename "/pxelinux.0";
	}
EOF
	}

	print "}\n";
}

exit;

print <<"EOF";
# MAGIC OF OPTION 82
subnet 87.76.242.0 netmask 255.255.255.0 {
	authoritative;
	option routers 87.76.242.1;

EOF

for my $net (@nets) {
	next if (!defined($net->{management}));
	my $name = $net->{name};
	my $mgmt = $net->{management};
	my $port = $portmap{$name};

	print <<"EOF";
	class "$name" {
		match if binary-to-ascii (10, 8, "/", suffix ( option agent.circuit-id, 2)) = "$port";
	}
	pool {
		allow members of "$name";
		range $mgmt;
		option host-name "$name";
	}
EOF
}

print "}\n";
