#! /usr/bin/perl -w
use strict;

my $date = `date --rfc-2822`;
chomp $date;

my @nets = ();
open NAMES, "switches.txt"
	or die "switches.txt: $!";
while (<NAMES>) {
	chomp;
	/87\.76\.(\d+\.\d+)\s+(\d+)\s+(\S+)/ or next;
	push @nets, {
		net => $1,
		netmask => $2,
		name => $3
	};
}	

print <<"EOF";
// Autogenerated by make-named-secondary.pl at $date. Do not edit manually! 

acl tg-nett  { 87.76.0.0/16; 2001:8c0:9804::/48; 127.0.0.0/8; ::1; };
acl     ns-xfr     { 194.19.3.20; 87.76.254.2; 87.76.255.2; 87.76.250.0/24; };
acl     ripe-xfr   { 194.19.3.20; 87.76.254.2; 87.76.255.2; 193.0.0.0/22; };
masters bootstrap  { 87.76.254.2; 2001:8c0:9804:254::2; };

options {
        directory "/etc/bind";
	allow-recursion { tg-nett; };
	allow-query { any; };
	allow-transfer { ns-xfr; }; 
	auth-nxdomain no;
	recursion yes;
        listen-on-v6 { any; };
};

zone "." { type hint; file "db.root"; };

zone "0.0.127.in-addr.arpa" {
	type master;
	file "0.0.127.in-addr.arpa";
	notify no;
};

zone "tg09.gathering.org" {
	type slave;
	notify no;
	masters { bootstrap; };
	file "slave/tg09.gathering.org";
};

 
key DHCP_UPDATER {
	algorithm HMAC-MD5.SIG-ALG.REG.INT;
	secret seGDD1r9u8iEAnEAetd9fg==;
};

zone "76.87.in-addr.arpa" {
	type slave;
	notify no;
	masters { bootstrap; };
	file "slave/76.87.in-addr.arpa";	
	allow-transfer { ripe-xfr; }; 
};

zone "4.0.8.9.0.c.8.0.1.0.0.2.ip6.arpa" {
        type slave;
        notify no;
        masters { bootstrap; };
        file "slave/4.0.8.9.0.c.8.0.1.0.0.2.ip6.arpa";
        allow-transfer { ns-xfr; }; 
};

// local hax
zone "www.battle.net" {
        type slave;
        notify no;
        masters { bootstrap; };
		  file "slave/www.battle.net";
};

// Testing av v6-oppslag
// -berge
zone "v6dnstest.tg09.gathering.org" {
	type slave;
	notify no;
   masters { bootstrap; };
	file "slave/v6dnstest.tg09.gathering.org";
	allow-transfer { ns-xfr; };
};

// ns1.powertech.no er lol og tar ikke mot notifies. Vi har dårlig tid, og fikser lokalt.
zone "advarsel.gathering.org" {
        type slave;
        notify no;
        masters { bootstrap; };
		  file "slave/advarsel.gathering.org";
};

zone "warning.gathering.org" {
        type slave;
        notify no;
        masters { bootstrap; };
		  file "slave/warning.gathering.org";
};

EOF

if ( -f "/etc/bind/infra.tg09.gathering.org" )
{
	print <<"EOF";
zone "infra.tg09.gathering.org" {
	type slave;
	notify no;
	file "slave/infra.tg09.gathering.org";
	allow-transfer { ns-xfr; };
};
EOF
}

for my $net (@nets) {
	my $d = $net->{name};

	print <<"EOF";
zone "$d.tg09.gathering.org" {
	type slave;
	notify no;
	masters { bootstrap; };
	file "slave/$d.tg09.gathering.org";
	allow-transfer { ns-xfr; }; 
};
EOF
}

for (my $i=0 ; $i <= 255; ++$i ) {
        my $zone = "$i.76.87.in-addr.arpa";

print <<"EOF"
zone "$zone" {
         type slave;
         notify no;
         file \"slave/$zone\";
         masters { bootstrap; };
};
EOF

};

