#! /usr/bin/perl -w
use strict;

my $date = `date --rfc-2822`;
chomp $date;

my @nets = ();
open NAMES, "switches.txt"
	or die "switches.txt: $!";
while (<NAMES>) {
	chomp;
	/\d+\.\d+\.(\d+\.\d+)\s+(\d+)\s+(\S+)/ or next;
	push @nets, {
		net => $1,
		netmask => $2,
		name => $3
	};
}	

print <<"EOF";
// Autogenerated by make-named.pl at $date. Do not edit manually! 

acl tg-nett  { 87.76.0.0/16; 2001:8c0:9804::/48; 127.0.0.0/8; ::1; };
acl ns-xfr   { 194.19.3.20; 87.76.254.2; 87.76.255.2; 87.76.250.0/24; };
acl ripe-xfr { 194.19.3.20; 87.76.254.2; 87.76.255.2; 193.0.0.0/22; };

options {
	directory "/etc/bind";
	allow-recursion { tg-nett; };
	allow-query { any; };
	allow-transfer { ns-xfr; }; 
	recursion yes;
	auth-nxdomain no;
	listen-on-v6 { any; };
};

zone "." { type hint; file "db.root"; };

zone "0.0.127.in-addr.arpa" {
	type master;
	file "0.0.127.in-addr.arpa";
	notify no;
};

zone "tg09.gathering.org" {
	type master;
	file "tg09.gathering.org";
	notify yes;
	//allow-transfer { 87.76.255.2; };
	allow-transfer { ns-xfr; }; 
};
 
key DHCP_UPDATER {
	algorithm HMAC-MD5.SIG-ALG.REG.INT;
	secret seGDD1r9u8iEAnEAetd9fg==;
};

zone "76.87.in-addr.arpa" {
	type master;
	allow-update { key DHCP_UPDATER; };
	notify yes;
	file "76.87.in-addr.arpa";	
	//allow-transfer { 194.19.3.20; 87.76.255.2; 193.0.0.0/22; };
	allow-transfer { ripe-xfr; }; 
};

zone "4.0.8.9.0.c.8.0.1.0.0.2.ip6.arpa" {
	type master;
	allow-update { key DHCP_UPDATER; };
	notify yes;
	file "4.0.8.9.0.c.8.0.1.0.0.2.ip6.arpa";
	//allow-transfer { 194.19.3.20; 87.76.255.2; };
	allow-transfer { ns-xfr; }; 
};

// local hax
zone "www.battle.net" {
	type master;
	notify yes;
	file "www.battle.net";
};

// Testing av v6-oppslag
// -berge
zone "v6dnstest.tg09.gathering.org" {
	type master;
	allow-update { key DHCP_UPDATER; };
	notify yes;
	file "dynamic/v6dnstest.tg09.gathering.org";
	allow-transfer { ns-xfr; };
};

// ns1.powertech.no er lol og tar ikke mot notifies. Vi har dårlig tid, og fikser lokalt.
zone "advarsel.gathering.org" {
	type master;
	notify yes;
	file "advarsel.gathering.org";
};

zone "warning.gathering.org" {
	type master;
	notify yes;
	file "warning.gathering.org";
};

EOF

if ( -f "/etc/bind/infra.tg09.gathering.org" )
{
	print <<"EOF";
zone "infra.tg09.gathering.org" {
	type master;
	notify yes;
	file "infra.tg09.gathering.org";
	allow-transfer { ns-xfr; };
};
EOF
}

for my $net (@nets) {
	my $domain = $net->{name};
	print <<"EOF";
zone "$domain.tg09.gathering.org" {
	type master;
	allow-update { key DHCP_UPDATER; };
	notify yes;
	file "dynamic/$domain.tg09.gathering.org";
	allow-transfer { ns-xfr; };
};
EOF
}

print "include \"/etc/bind/named.reverse.conf\";";
