#!/usr/bin/perl

use strict;

my $top_of_clients = 76;

my @static_switches = (
	 	118, 119, 120, 130, 131, 200, 202, 
		204, 205, 206, 207, 208, 209, 201,
		212, 213, 215, 216, 220, 222, 223, 
		224, 225, 250, 148, 149, 150, 151,
		226
	);

my @static_nets = (
		0, 239, 240, 241, 242, 243, 251,
		252, 253, 254, 255
	);

my $date = `date --rfc-2822`;
chomp $date;
my $serial = `date +%Y%m%d%M`;
chomp $serial;

my @nets = ();
open NAMES, "switches.txt"
	or die "switches.txt: $!";
while (<NAMES>) {
	chomp;
	/87\.76\.(\d+\.\d+)\s+(\d+)\s+(\S+)(?:\s+(\S+))?/ or next;
	
	my $mgmt = $4;

	push @nets, {
		net => $1,
		netmask => $2,
		name => $3,
		management => $mgmt
	};
}	


# Først, generer alle C-nett i nederste den av IP-range: 
open NFILE, ">", "/etc/bind/named.reverse.conf" or die $!;

for (my $i=1 ; $i <= $top_of_clients; ++$i ) {
        my $zone = "$i.76.87.in-addr.arpa";

print NFILE "zone \"$zone\" {
         type master;
	 allow-update { key DHCP_UPDATER; };
         notify yes;
         file \"reverse/$zone\";
         allow-transfer { 87.76.255.2; 193.0.0.0/22; };\n\n};\n\n";

        open ZFILE, ">", "/etc/bind/reverse/$zone" or die $!;
        print ZFILE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
\$TTL 3600
@       IN      SOA     for.tg09.gathering.org. abuse.gathering.org. (
                        $serial   ; serial
                        3600 ; refresh
                        1800 ; retry
                        608400 ; expire
                        3600 ) ; minimum and default TTL

                IN      NS      for.tg09.gathering.org.
                IN      NS      while.tg09.gathering.org.

\$ORIGIN $zone.
EOF
};

# Deretter, alle static nett i øverste delen av IP-range: 
open NFILE, ">>", "/etc/bind/named.reverse.conf" or die $!;

foreach my $i ( @static_switches ) {
        my $zone = "$i.76.87.in-addr.arpa";

print NFILE "zone \"$zone\" {
         type master;
	 allow-update { key DHCP_UPDATER; };
         notify yes;
         file \"reverse/$zone\";
         allow-transfer { 87.76.255.2; 193.0.0.0/22; };\n\n};\n\n";

        open ZFILE, ">", "/etc/bind/reverse/$zone" or die $!;
        print ZFILE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
\$TTL 3600
@       IN      SOA     for.tg09.gathering.org. abuse.gathering.org. (
                        $serial   ; serial
                        3600 ; refresh
                        1800 ; retry
                        608400 ; expire
                        3600 ) ; minimum and default TTL

                IN      NS      for.tg09.gathering.org.
                IN      NS      while.tg09.gathering.org.

\$ORIGIN $zone.
EOF
};



foreach my $i ( @static_nets ) {
        my $zone = "$i.76.87.in-addr.arpa";

print NFILE "zone \"$zone\" {
         type master;
//	 allow-update { key DHCP_UPDATER; };
         notify yes;
         file \"reverse/$zone\";
         allow-transfer { 87.76.255.2; 193.0.0.0/22; };\n\n};\n\n";

        open ZFILE, ">", "/etc/bind/reverse/$zone" or die $!;
        print ZFILE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
\$TTL 3600
@       IN      SOA     for.tg09.gathering.org. abuse.gathering.org. (
                        $serial   ; serial
                        3600 ; refresh
                        1800 ; retry
                        608400 ; expire
                        3600 ) ; minimum and default TTL

                IN      NS      for.tg09.gathering.org.
                IN      NS      while.tg09.gathering.org.

\$ORIGIN $zone.
EOF
};



close NFILE;
