--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = public, pg_catalog;

--
-- Name: datarate; Type: TYPE; Schema: public; Owner: nms
--

CREATE TYPE datarate AS (
	switch integer,
	port integer,
	bytes_in double precision,
	bytes_out double precision
);


ALTER TYPE public.datarate OWNER TO nms;

--
-- Name: get_current_datarate(); Type: FUNCTION; Schema: public; Owner: nms
--

CREATE FUNCTION get_current_datarate() RETURNS SETOF datarate
    AS $$
DECLARE
        num_entries INTEGER;
        poll polls;
        first_poll polls;
        last_poll polls;
        timediff float;
        ret datarate;
BEGIN
        num_entries := 0;
        last_poll.switch := -1;

        FOR poll IN select * from polls where time >= now() - '15 minutes'::interval and time < now() order by switch,port,time LOOP
                IF poll.switch <> last_poll.switch OR poll.port <> last_poll.port THEN
                        IF num_entries >= 2 THEN
                                timediff := EXTRACT(epoch from last_poll.time - first_poll.time);
                                ret.switch := last_poll.switch;
                                ret.port := last_poll.port;

                                IF last_poll.bytes_in >= first_poll.bytes_in AND last_poll.bytes_out >= first_poll.bytes_out THEN
                                        ret.bytes_in := (last_poll.bytes_in - first_poll.bytes_in) / timediff;
                                        ret.bytes_out := (last_poll.bytes_out - first_poll.bytes_out) / timediff;
                                        return next ret; 
                                END IF;
                        END IF;
                        num_entries := 0;
                ELSE
                        -- reset if we have wraparound
                        IF last_poll.bytes_in < first_poll.bytes_in OR
                           last_poll.bytes_out < first_poll.bytes_out THEN
                                num_entries := 0;
                        END IF;
                END IF;

                num_entries := num_entries + 1;
                IF num_entries = 1 THEN
                        first_poll.switch := poll.switch;
                        first_poll.port := poll.port;
                        first_poll.time := poll.time;
                        first_poll.bytes_in := poll.bytes_in;
                        first_poll.bytes_out := poll.bytes_out;
                END IF;

                last_poll.switch := poll.switch;
                last_poll.port := poll.port;
                last_poll.time := poll.time;
                last_poll.bytes_in := poll.bytes_in;
                last_poll.bytes_out := poll.bytes_out;
        END LOOP;

        -- last
        IF num_entries >= 2 THEN
                timediff := EXTRACT(epoch from last_poll.time - first_poll.time);
                ret.switch := last_poll.switch;
                ret.port := last_poll.port;

                IF last_poll.bytes_in >= first_poll.bytes_in AND
                   last_poll.bytes_out >= first_poll.bytes_out THEN
                        ret.bytes_in := (last_poll.bytes_in - first_poll.bytes_in) / timediff;
                        ret.bytes_out := (last_poll.bytes_out - first_poll.bytes_out) / timediff;
                        return next ret; 
                END IF;
        END IF;

        RETURN;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.get_current_datarate() OWNER TO nms;

--
-- Name: get_datarate(); Type: FUNCTION; Schema: public; Owner: nms
--

CREATE FUNCTION get_datarate() RETURNS SETOF datarate
    AS $$
DECLARE
        num_entries INTEGER;
        poll polls;
        second_last_poll polls;
        last_poll polls;
        timediff float;
        ret datarate;
BEGIN
        num_entries := 0;
        last_poll.switch = -1;

        FOR poll IN select * from polls where time >= now() - '15 minutes'::interval and time < now() order by switch,port,time LOOP
                IF poll.switch <> last_poll.switch OR poll.port <> last_poll.port THEN
                        IF num_entries >= 2 THEN
                                timediff := EXTRACT(epoch from last_poll.time - second_last_poll.time);
                                ret.switch := last_poll.switch;
                                ret.port := last_poll.port;
                                
                                IF last_poll.bytes_in < second_last_poll.bytes_in THEN
                                        second_last_poll.bytes_in = 0;
                                END IF;
                                IF last_poll.bytes_out < second_last_poll.bytes_out THEN
                                        second_last_poll.bytes_out = 0;
                                END IF;

                                ret.bytes_in := (last_poll.bytes_in - second_last_poll.bytes_in) / timediff;
                                ret.bytes_out := (last_poll.bytes_out - second_last_poll.bytes_out) / timediff;
                                return next ret;
                        ELSIF num_entries = 1 THEN
                                ret.switch := last_poll.switch;
                                ret.port := last_poll.port;
                                ret.bytes_in := -1;
                                ret.bytes_out := -1;
                                return next ret;
                        END IF;
                        num_entries := 1;
                ELSE
                        num_entries := num_entries + 1;
                END IF;
                second_last_poll.switch := last_poll.switch;
                second_last_poll.port := last_poll.port;
                second_last_poll.time := last_poll.time;
                second_last_poll.bytes_in := last_poll.bytes_in;
                second_last_poll.bytes_out := last_poll.bytes_out;
                last_poll.switch := poll.switch;
                last_poll.port := poll.port;
                last_poll.time := poll.time;
                last_poll.bytes_in := poll.bytes_in;
                last_poll.bytes_out := poll.bytes_out;
        END LOOP;
       -- pah, and once more, for the last switch/port...
        IF num_entries >= 2 THEN
                timediff := EXTRACT(epoch from last_poll.time - second_last_poll.time);
                ret.switch := last_poll.switch;
                ret.port := last_poll.port;
                
                IF last_poll.bytes_in < second_last_poll.bytes_in THEN
                        second_last_poll.bytes_in = 0;
                END IF;
                IF last_poll.bytes_out < second_last_poll.bytes_out THEN
                        second_last_poll.bytes_out = 0;
                END IF;

                ret.bytes_in := (last_poll.bytes_in - second_last_poll.bytes_in) / timediff;
                ret.bytes_out := (last_poll.bytes_out - second_last_poll.bytes_out) / timediff;
                return next ret;
        ELSIF num_entries = 1 THEN
                ret.switch := last_poll.switch;
                ret.port := last_poll.port;
                ret.bytes_in := -1;
                ret.bytes_out := -1;
                return next ret;
        END IF;
        
        RETURN;
END;
$$
    LANGUAGE plpgsql;


ALTER FUNCTION public.get_datarate() OWNER TO nms;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: backup_polls; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE backup_polls (
    "time" timestamp with time zone,
    switch integer,
    port integer,
    bytes_in bigint,
    bytes_out bigint,
    errors_in bigint,
    errors_out bigint
);


ALTER TABLE public.backup_polls OWNER TO nms;

--
-- Name: cpuloadpoll_id_seq; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE cpuloadpoll_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cpuloadpoll_id_seq OWNER TO nms;

--
-- Name: cpuloadpoll; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE cpuloadpoll (
    id integer DEFAULT nextval('cpuloadpoll_id_seq'::regclass) NOT NULL,
    "time" timestamp without time zone NOT NULL,
    switch integer NOT NULL,
    entity integer NOT NULL,
    value integer NOT NULL
);


ALTER TABLE public.cpuloadpoll OWNER TO nms;

--
-- Name: dhcp; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE dhcp (
    switch integer NOT NULL,
    network cidr NOT NULL,
    last_ack timestamp without time zone,
    owner_color character varying
);


ALTER TABLE public.dhcp OWNER TO nms;

--
-- Name: ipv4; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ipv4 (
    mac macaddr NOT NULL,
    address inet NOT NULL,
    "time" timestamp without time zone NOT NULL
);


ALTER TABLE public.ipv4 OWNER TO postgres;

--
-- Name: ipv6; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ipv6 (
    mac macaddr NOT NULL,
    address inet NOT NULL,
    "time" timestamp with time zone NOT NULL,
    age integer,
    vlan text
);


ALTER TABLE public.ipv6 OWNER TO postgres;

--
-- Name: mbd_log; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE mbd_log (
    ts timestamp without time zone,
    game character varying,
    port integer,
    description character varying,
    active_servers integer
);


ALTER TABLE public.mbd_log OWNER TO postgres;

--
-- Name: placements; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE placements (
    switch integer NOT NULL,
    placement box NOT NULL,
    zorder integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.placements OWNER TO nms;

--
-- Name: polls; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE polls (
    "time" timestamp with time zone NOT NULL,
    switch integer NOT NULL,
    port integer NOT NULL,
    bytes_in bigint NOT NULL,
    bytes_out bigint NOT NULL,
    errors_in bigint NOT NULL,
    errors_out bigint NOT NULL
);
ALTER TABLE ONLY polls ALTER COLUMN "time" SET STATISTICS 100;


ALTER TABLE public.polls OWNER TO nms;

--
-- Name: polls_poll_seq; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE polls_poll_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.polls_poll_seq OWNER TO nms;

--
-- Name: portnames; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE portnames (
    switchtype character varying NOT NULL,
    port integer NOT NULL,
    description character varying NOT NULL
);


ALTER TABLE public.portnames OWNER TO nms;

--
-- Name: squeue; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE squeue (
    id integer DEFAULT nextval(('squeue_sequence'::text)::regclass) NOT NULL,
    gid integer NOT NULL,
    added timestamp with time zone NOT NULL,
    updated timestamp with time zone,
    addr inet,
    cmd character varying NOT NULL,
    locked boolean DEFAULT false NOT NULL,
    processed boolean DEFAULT false NOT NULL,
    disabled boolean DEFAULT false NOT NULL,
    priority integer DEFAULT 3,
    sysname character varying NOT NULL,
    author character varying NOT NULL,
    result character varying,
    delay timestamp with time zone,
    delaytime interval DEFAULT '00:01:00'::interval
);


ALTER TABLE public.squeue OWNER TO nms;

--
-- Name: squeue_group_sequence; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE squeue_group_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.squeue_group_sequence OWNER TO nms;

--
-- Name: squeue_sequence; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE squeue_sequence
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.squeue_sequence OWNER TO nms;

--
-- Name: stemppoll_sequence; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE stemppoll_sequence
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.stemppoll_sequence OWNER TO nms;

--
-- Name: switches; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE switches (
    switch integer DEFAULT nextval(('"switches_switch_seq"'::text)::regclass) NOT NULL,
    ip inet NOT NULL,
    sysname character varying NOT NULL,
    switchtype character varying NOT NULL,
    last_updated timestamp with time zone,
    locked boolean DEFAULT false NOT NULL,
    priority integer DEFAULT 0 NOT NULL,
    poll_frequency interval DEFAULT '00:05:00'::interval NOT NULL,
    community character varying DEFAULT 'public'::character varying NOT NULL
);


ALTER TABLE public.switches OWNER TO nms;

--
-- Name: switches_switch_seq; Type: SEQUENCE; Schema: public; Owner: nms
--

CREATE SEQUENCE switches_switch_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.switches_switch_seq OWNER TO nms;

--
-- Name: switchtypes; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE switchtypes (
    switchtype character varying NOT NULL,
    ports character varying NOT NULL,
    wide_counters boolean DEFAULT false NOT NULL
);


ALTER TABLE public.switchtypes OWNER TO nms;

--
-- Name: temppoll; Type: TABLE; Schema: public; Owner: nms; Tablespace: 
--

CREATE TABLE temppoll (
    id integer DEFAULT nextval(('stemppoll_sequence'::text)::regclass) NOT NULL,
    "time" timestamp without time zone NOT NULL,
    switch integer NOT NULL,
    temp double precision
);


ALTER TABLE public.temppoll OWNER TO nms;

--
-- Name: cpuloadpoll_pkey; Type: CONSTRAINT; Schema: public; Owner: nms; Tablespace: 
--

ALTER TABLE ONLY cpuloadpoll
    ADD CONSTRAINT cpuloadpoll_pkey PRIMARY KEY (id);


--
-- Name: ipv4_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY ipv4
    ADD CONSTRAINT ipv4_pkey PRIMARY KEY (mac, address, "time");


--
-- Name: ipv6_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY ipv6
    ADD CONSTRAINT ipv6_pkey PRIMARY KEY (mac, address, "time");


--
-- Name: switches_pkey; Type: CONSTRAINT; Schema: public; Owner: nms; Tablespace: 
--

ALTER TABLE ONLY switches
    ADD CONSTRAINT switches_pkey PRIMARY KEY (switch);


--
-- Name: switchtypes_pkey; Type: CONSTRAINT; Schema: public; Owner: nms; Tablespace: 
--

ALTER TABLE ONLY switchtypes
    ADD CONSTRAINT switchtypes_pkey PRIMARY KEY (switchtype);


--
-- Name: polls_switchporttime; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE INDEX polls_switchporttime ON polls USING btree (switch, port, "time");


--
-- Name: polls_time; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE INDEX polls_time ON polls USING btree ("time");


--
-- Name: switches_dhcp; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE UNIQUE INDEX switches_dhcp ON dhcp USING btree (switch);


--
-- Name: switches_placement; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE UNIQUE INDEX switches_placement ON placements USING btree (switch);


--
-- Name: switches_switch; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE UNIQUE INDEX switches_switch ON switches USING btree (switch);


--
-- Name: temppoll_search; Type: INDEX; Schema: public; Owner: nms; Tablespace: 
--

CREATE INDEX temppoll_search ON temppoll USING btree (switch, id);


--
-- Name: time_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX time_idx ON ipv6 USING btree ("time");


--
-- Name: timev4_idx; Type: INDEX; Schema: public; Owner: postgres; Tablespace: 
--

CREATE INDEX timev4_idx ON ipv4 USING btree ("time");


--
-- Name: switches_switchtype_fkey; Type: FK CONSTRAINT; Schema: public; Owner: nms
--

ALTER TABLE ONLY switches
    ADD CONSTRAINT switches_switchtype_fkey FOREIGN KEY (switchtype) REFERENCES switchtypes(switchtype);


--
-- Name: temppoll_switch_fkey; Type: FK CONSTRAINT; Schema: public; Owner: nms
--

ALTER TABLE ONLY temppoll
    ADD CONSTRAINT temppoll_switch_fkey FOREIGN KEY (switch) REFERENCES switches(switch);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: ipv4; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE ipv4 FROM PUBLIC;
REVOKE ALL ON TABLE ipv4 FROM postgres;
GRANT ALL ON TABLE ipv4 TO postgres;
GRANT SELECT,INSERT ON TABLE ipv4 TO nms;


--
-- Name: ipv6; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE ipv6 FROM PUBLIC;
REVOKE ALL ON TABLE ipv6 FROM postgres;
GRANT ALL ON TABLE ipv6 TO postgres;
GRANT SELECT,INSERT ON TABLE ipv6 TO nms;


--
-- Name: mbd_log; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE mbd_log FROM PUBLIC;
REVOKE ALL ON TABLE mbd_log FROM postgres;
GRANT ALL ON TABLE mbd_log TO postgres;
GRANT SELECT,INSERT ON TABLE mbd_log TO nms;


--
-- PostgreSQL database dump complete
--

