#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <malloc.h>
#include <vector>
#include <algorithm>
#include <pqxx/pqxx>
#include "graph.h"
#include "flowpusher.h"
#include "flowutil.h"

namespace pqxx {
	template<>
	void from_string<long long>(const char *from, long long &to)
	{
		to = atoll(from);
	}
}
						

int main(int argc, char **argv)
{
	int width = 1000, height = 500;
	pqxx::connection conn05("dbname=nms05 host=localhost user=nms password=removed");
	pqxx::connection conn("dbname=nms host=localhost user=nms password=removed");

	std::vector<flow_element> flow, total_flow, total_flow05;
	FlowPusher fp(flow);
	int last_port = -1;
	
	mallopt(M_TRIM_THRESHOLD, -1);
	
	int num_total = 0;
	pqxx::work t(conn, "fetch_all");
	pqxx::icursorstream::icursorstream cstream(t, "select port,extract(epoch from time) as time,bytes_in,bytes_out from polls natural join switches where ((switchtype='es3024' and port < 25) or (switchtype='summit400' and port > 1)) order by switch,port,time", "fetch_all", 500);
	
	for ( ;; ) {
		pqxx::result res;
		
		cstream >> res;
		if (res.empty()) 
			break;

		for (unsigned i = 0; i < res.size(); ++i) {
			int port = res[i][0].as<int>();
			double x = res[i][1].as<double>();
			unsigned long long y1 = res[i][2].as<long long>(), y2 = res[i][3].as<long long>();

			if (port != last_port) {
				if (last_port != -1) {
					total_flow = sum_flows(total_flow, flow);
					fprintf(stderr, "%u (%u)\n", last_port, ++num_total);
				}

				// reset
				last_port = port;
				fp.reset(x, y1, y2);
				continue;
			}

			fp.push(x, y1, y2);
		}
	}
	total_flow = sum_flows(total_flow, flow);

	unsigned long long min_y = 0;
	unsigned long long max_y = 10000000;

	for (unsigned i = 0; i < total_flow.size(); ++i) {
		flow_element fe = total_flow[i];
		
		min_y = std::min(min_y, fe.y1);
		max_y = std::max(max_y, fe.y1);
		
		min_y = std::min(min_y, fe.y2);
		max_y = std::max(max_y, fe.y2);
	}

	printf("06 done.\n");
	
	num_total = 0;
	pqxx::work t05(conn05, "fetch_all");
	pqxx::icursorstream::icursorstream cstream05(t05, "select port,extract(epoch from (time + interval '1 year 20 days')) as time,bytes_in,bytes_out from polls natural join switches where (switchtype='es3024' and port < 25) order by switch,port,time", "fetch_all", 500);

	last_port = -1;
	
	for ( ;; ) {
		pqxx::result res;
	
		cstream05 >> res;
		if (res.empty()) 
			break;
	
		for (unsigned i = 0; i < res.size(); ++i) {
			int port = res[i][0].as<int>();
			double x = res[i][1].as<double>();
			unsigned long long y1 = res[i][2].as<long long>(), y2 = res[i][3].as<long long>();

			if (port != last_port) {
				if (last_port != -1) {
					total_flow05 = sum_flows(total_flow05, filter_flow(flow));
					fprintf(stderr, "TG05: %u (%u)\n", last_port, ++num_total);
				}

				// reset
				last_port = port;
				fp.reset(x, y1, y2);
				continue;
			}

			fp.push(x, y1, y2);
		}
	}
	total_flow05 = sum_flows(total_flow05, filter_flow(flow));

	for (unsigned i = 0; i < total_flow05.size(); ++i) {
		flow_element fe = total_flow05[i];
		
		min_y = std::min(min_y, fe.y1);
		max_y = std::max(max_y, fe.y1);
		
		min_y = std::min(min_y, fe.y2);
		max_y = std::max(max_y, fe.y2);
	}
	
	double min_x = std::min(total_flow[0].x, total_flow05[0].x);
	double max_x = std::max(total_flow[total_flow.size() - 1].x, total_flow05[total_flow05.size() - 1].x);
	
	graph *g = mygraph_new(width, height);
	g = mygraph_make_graph(g, min_x, max_x, min_y, max_y, 5);

	// PLOT FIRST
	int *x = new int[total_flow.size()];
	unsigned long long *y1 = new unsigned long long[total_flow.size()];
	unsigned long long *y2 = new unsigned long long[total_flow.size()];

	// de-interleave
	for (unsigned i = 0; i < total_flow.size(); ++i) {
		x[i] = total_flow[i].x;
		y1[i] = total_flow[i].y1;
		y2[i] = total_flow[i].y2;
	}

	mygraph_plot_series(g, x, y1, total_flow.size(), 1.0f, 0.0f, 0.0f);
	mygraph_plot_series(g, x, y2, total_flow.size(), 0.0f, 0.0f, 1.0f);

	delete[] x;
	delete[] y1;
	delete[] y2;
	
	// PLOT SECOND
	x = new int[total_flow05.size()];
	y1 = new unsigned long long[total_flow05.size()];
	y2 = new unsigned long long[total_flow05.size()];

	// de-interleave
	for (unsigned i = 0; i < total_flow05.size(); ++i) {
		x[i] = total_flow05[i].x;
		y1[i] = total_flow05[i].y1;
		y2[i] = total_flow05[i].y2;
	}

	mygraph_plot_series(g, x, y1, total_flow05.size(), 0.0f, 1.0f, 0.0f);
	mygraph_plot_series(g, x, y2, total_flow05.size(), 1.0f, 0.0f, 1.0f);

	delete[] x;
	delete[] y1;
	delete[] y2;
	
	mygraph_to_file(g, "comparative.png");
	mygraph_cleanup(g);
}
