#ifndef _FLOWPUSHER_H
#define _FLOWPUSHER_H 1

struct flow_element {
	unsigned x;
	unsigned long long y1, y2;
};

class FlowPusher
{
private:
	std::vector<flow_element> &flow;
	unsigned min_x, max_x;
	long long unsigned min_y, max_y;
	double prev_x;
	unsigned long long prev_y1, prev_y2;
	
public:
	FlowPusher(std::vector<flow_element> &flow);
	void reset(double x, unsigned long long y1, unsigned long long y2);
	void push(double x, unsigned long long y1, unsigned long long y2);
	static void find_diff(double x, double &prev_x, unsigned long long y1, unsigned long long prev_y1, unsigned long long y2, unsigned long long prev_y2,
		unsigned long long &yf1, unsigned long long &yf2);
	
	unsigned get_min_x() { return min_x; }
	unsigned get_max_x() { return max_x; }
	unsigned get_min_y() { return min_y; }
	unsigned get_max_y() { return max_y; }
};

#endif /* !defined(_FLOWPUSHER_H) */
