#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <malloc.h>
#include <vector>
#include <algorithm>
#include "graph.h"
#include "flowutil.h"

std::vector<flow_element> sum_flows(const std::vector<flow_element> &a, const std::vector<flow_element> &b)
{
	std::vector<flow_element> ret;
	std::vector<flow_element>::const_iterator ia = a.begin(), ib = b.begin();

	double last_xa = 0.0, last_y1a = 0.0, last_y2a = 0.0;
	double last_xb = 0.0, last_y1b = 0.0, last_y2b = 0.0;
	
	while (ia != a.end() && ib != b.end()) {
		if (ia->x == ib->x) {
			flow_element fea = *ia, feb = *ib, fe;
			
			last_xa = fea.x;
			last_y1a = fea.y1;
			last_y2a = fea.y2;
			
			last_xb = feb.x;
			last_y1b = feb.y1;
			last_y2b = feb.y2;
		
			fe.x = fea.x;
			fe.y1 = fea.y1 + feb.y1;
			fe.y2 = fea.y2 + feb.y2;

			ret.push_back(fe);

			++ia, ++ib;
		} else if (ia->x < ib->x) {
			flow_element fe = *ia;
			
			last_xa = fe.x;
			last_y1a = fe.y1;
			last_y2a = fe.y2;
			
			double t = (fe.x - last_xb) / (ib->x - last_xb);
			fe.y1 += last_y1b + t * (ib->y1 - last_y1b);
			fe.y2 += last_y2b + t * (ib->y2 - last_y2b);

			ret.push_back(fe);

			++ia;
		} else {
			flow_element fe = *ib;
			
			last_xb = fe.x;
			last_y1b = fe.y1;
			last_y2b = fe.y2;
			
			double t = (fe.x - last_xa) / (ia->x - last_xa);
			fe.y1 += last_y1a + t * (ia->y1 - last_y1a);
			fe.y2 += last_y2a + t * (ia->y2 - last_y2a);

			ret.push_back(fe);
			++ib;
		}
	}

	while (ia != a.end()) {
		ret.push_back(*ia);
		++ia;
	}
	while (ib != b.end()) {
		ret.push_back(*ib);
		++ib;
	}

	return ret;
}

std::vector<flow_element> filter_flow(const std::vector<flow_element> &flow)
{
	unsigned long long last_y1 = 0, last_y2 = 0;
	std::vector<flow_element> ret;
	
	for (std::vector<flow_element>::const_iterator i = flow.begin(); i != flow.end(); ++i) {
/*		if ((i->y1 > 100000 && last_y1 < 10000 && i->y2 > 100000 && last_y2 < 1000) ||
		    (last_y1 > 10000 && last_y2 > 10000 && i->y1 / last_y1 > 10 && i->y2 / last_y2 > 10)) {
			printf("yoyo: %llu %llu (%llu %llu)\n", i->y1, i->y2, last_y1, last_y2);
		} else {
			ret.push_back(*i);
			last_y1 = i->y1;
			last_y2 = i->y2;
		} */
		if (!(i->x >= 1145056800 && i->x <= 1145070800)) {
			ret.push_back(*i);
		}
	}

	return ret;
}

void make_graph(int port, unsigned width, unsigned height, unsigned min_x, unsigned max_x, unsigned long long min_y, unsigned long long max_y, std::vector<flow_element> &flow)
{
	char filename[256];
	graph *g = mygraph_new(width, height);
	g = mygraph_make_graph(g, min_x, max_x, min_y, max_y, 5);

	int *x = new int[flow.size()];
	unsigned long long *y1 = new unsigned long long[flow.size()];
	unsigned long long *y2 = new unsigned long long[flow.size()];

	// de-interleave
	for (unsigned i = 0; i < flow.size(); ++i) {
		x[i] = flow[i].x;
		y1[i] = flow[i].y1;
		y2[i] = flow[i].y2;
	}

	mygraph_plot_series(g, x, y1, flow.size(), 1.0f, 0.0f, 0.0f);
	mygraph_plot_series(g, x, y2, flow.size(), 0.0f, 0.0f, 1.0f);
	sprintf(filename, "port-%u-500-250.png", port);
	mygraph_to_file(g, filename);
	mygraph_cleanup(g);

	delete[] x;
	delete[] y1;
	delete[] y2;
}

