/* Copyright (C) 2006 Kjetil Ørbekk, Norway */

#include <cairo.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

typedef struct _graph {
  cairo_t *cr;
  cairo_surface_t *surface;
  int width;
  int height;
  int xoffset;
  double min_x;
  double max_x;
  double min_y;
  double max_y;
  double xs;
  double ys;
} graph;

void mygraph_fill_background(graph *mygraph);

void mygraph_draw_graph (cairo_t *cr, int x, int y );

graph *mygraph_new (int width, int height);

graph *mygraph_make_graph (graph *mygraph, double min_x,
			   double max_x, double min_y, double max_y,
			   int tickgran);

void mygraph_plot_series (graph *mygraph, int *xvals, unsigned long long *yvals,
			  int n_vals, double r, double g, double b);

void mygraph_to_file (graph *mygraph, char *filename);

void mygraph_cleanup (graph *self);

void mygraph_fill_background (graph *mygraph);

