%module mygraph
%{
#include "graph.c"
%}

%inline
%{
  // Add some helper functions for C arrays
  int *int_array(int size) {
    return (int *) malloc(sizeof(int)*size);
  }
  void int_destroy(int *a) {
    free(a);
  }
  void int_set(int *a, int i, int val) {
    a[i] = val;
  }
  int int_get(int *a, int i) {
    return a[i];
  }
%}

graph *mygraph_new (int width, int height);
graph *mygraph_make_graph (graph *mygraph, float min_x,
			   float max_x, float min_y, float max_y, int tickgran);
void mygraph_cleanup (graph *mygraph);
void mygraph_to_file (graph *mygraph, char *filename);
void mygraph_plot_series (graph *mygraph, int *xvals, int *yvals, int n_vals,
			  float r, float g, float b);
