#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <malloc.h>
#include <vector>
#include <algorithm>
#include <pqxx/pqxx>
#include "graph.h"
#include "flowpusher.h"
#include "flowutil.h"

namespace pqxx {
	template<>
	void from_string<long long>(const char *from, long long &to)
	{
		to = atoll(from);
	}
}
						
int main(int argc, char **argv)
{
	int width = 1000, height = 500;
	unsigned long long traffic = 0ULL;
	pqxx::connection conn("dbname=nms host=localhost user=nms password=removed");

	std::vector<flow_element> flow;
	int last_port = -1;
	
	mallopt(M_TRIM_THRESHOLD, -1);
	
	int num_total = 0;
	pqxx::work t(conn, "fetch_all");
	pqxx::icursorstream::icursorstream cstream(t, "select port,extract(epoch from time) as time,bytes_in,bytes_out from polls natural join switches where ((switchtype='es3024' and port < 25) or (switchtype='summit400' and port > 1)) order by switch,port,time", "fetch_all", 500);
//	pqxx::icursorstream::icursorstream cstream(t, "select port,extract(epoch from time) as time,bytes_in,bytes_out from polls natural join switches where switch=1447 order by switch,port,time", "fetch_all", 500);
	
	double prev_x;
	unsigned long long prev_y1, prev_y2;
	
	for ( ;; ) {
		pqxx::result res;
		
		cstream >> res;
		if (res.empty()) 
			break;

		for (unsigned i = 0; i < res.size(); ++i) {
			int port = res[i][0].as<int>();
			double x = res[i][1].as<double>();
			unsigned long long y1 = res[i][2].as<long long>(), y2 = res[i][3].as<long long>();

			if (port != last_port) {
				if (last_port != -1) {
					fprintf(stderr, "%.2f TB (%u)\n", traffic / double(1024.0 * 1024.0 * 1024.0 * 1024.0), ++num_total);
				}

				// reset
				last_port = port;
				prev_x = x;
				prev_y1 = y1;
				prev_y2 = y2;
				continue;
			}

			unsigned long long yf1, yf2;
			FlowPusher::find_diff(x, prev_x, y1, prev_y1, y2, prev_y2, yf1, yf2);
			traffic += 0.5 * (yf1 + yf2);
			
			prev_x = x;
			prev_y1 = y1;
			prev_y2 = y2;
		}
	}
	fprintf(stderr, "%.2f TB\n", traffic / double(1024.0 * 1024.0 * 1024.0 * 1024.0));
}
