#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <malloc.h>
#include <vector>
#include <algorithm>
#include <pqxx/pqxx>
#include "flowpusher.h"
#include "flowutil.h"

namespace pqxx {
	template<>
	void from_string<long long>(const char *from, long long &to)
	{
		to = atoll(from);
	}
}
						

int main(int argc, char **argv)
{
	int width = 1000, height = 500;
	pqxx::connection conn("dbname=nms host=localhost user=nms password=removed");

	std::vector<flow_element> flow, total_flow;
	FlowPusher fp(flow);
	int last_port = -1;
	
	mallopt(M_TRIM_THRESHOLD, -1);
	
	int num_total = 0;
	pqxx::work t(conn, "fetch_all");
	pqxx::icursorstream::icursorstream cstream(t, "select port,extract(epoch from time) as time,bytes_in,bytes_out from polls natural join switches where (switchtype='es3024' and port < 25) or (switchtype='summit400' and port > 1) order by switch,port,time", "fetch_all", 500);
	
	for ( ;; ) {
		pqxx::result res;
		
		cstream >> res;
		if (res.empty()) 
			break;

		for (unsigned i = 0; i < res.size(); ++i) {
			int port = res[i][0].as<int>();
			double x = res[i][1].as<double>();
			unsigned long long y1 = res[i][2].as<long long>(), y2 = res[i][3].as<long long>();

			if (port != last_port) {
				if (last_port != -1) {
					total_flow = sum_flows(total_flow, flow);
					fprintf(stderr, "%u (%u)\n", last_port, ++num_total);
				}

				// reset
				last_port = port;
				fp.reset(x, y1, y2);
				continue;
			}

			fp.push(x, y1, y2);
		}
	}

	unsigned long long min_y = 0;
	unsigned long long max_y = 10000000;

	for (unsigned i = 0; i < total_flow.size(); ++i) {
		flow_element fe = total_flow[i];
		
		min_y = std::min(min_y, fe.y1);
		max_y = std::max(max_y, fe.y1);
		
		min_y = std::min(min_y, fe.y2);
		max_y = std::max(max_y, fe.y2);
	}
	
	make_graph(65535, width, height, total_flow[0].x, total_flow[total_flow.size() - 1].x, min_y, max_y, total_flow);
}
