#! /usr/bin/perl

print "begin;\n";
print "delete from temppoll;\n";
print "delete from placements;\n";
print "delete from dhcp;\n";
print "delete from switches;\n";
print "SELECT pg_catalog.setval('switches_switch_seq', 1, false);\n";
print "SELECT pg_catalog.setval('polls_poll_seq', 1, false);\n";

open PATCHLIST, "../patchlist.txt"
	or die "../patchlist.txt: $!";

my $RANGE = "87.76.";

my $i = 1;
while (<PATCHLIST>) {
	chomp;
	my ($name, $distro, $port) = split / /;

	$name =~ /e(\d+)-(\d+)/;
	print $name;
	my ($e, $s) = ($1, $2);

	my $x = int(120 + $e * 12.27);
	my $y;

	$x += 7 if ($e >= 19);
	$x += 14 if ($e >= 35);
	$x += 9 if ($e >= 51);
	$x += 9 if ($e >= 68 && $s < 4);

	my ($c, $d); # tredje og fjerde oktett i IP-en
	if ($s > 3) {
		$c = $e + 1;
		$d = ($s - 4) * 64;

		$y = 600 - $s * 76 - ($s - 3) * 2;
	} else {
		$c = $e;
		$d = ($s - 1) * 64;

		$y = 663 - $s * 76;
	}

	my $xx = $x + 12;
	my $yy = $y + (($s > 3) ? 68 : 66);

	my ($ip, $range);
	if ($s == 1) {
		$ip = $RANGE . ($e) . ".2";
		$range = $RANGE . ($e) . ".0";
	} elsif ($s == 2) {
		$ip = $RANGE . ($e) . ".66";
		$range = $RANGE . ($e) . ".64";
	} elsif ($s == 3) {
		$ip = $RANGE . ($e) . ".130";
		$range = $RANGE . ($e) . ".128";
	} elsif ($s == 4) {
		$ip = $RANGE . ($e + 1) . ".2";
		$range = $RANGE . ($e + 1) . ".0";
	} elsif ($s == 5) {
		$ip = $RANGE . ($e + 1) . ".66";
		$range = $RANGE . ($e + 1) . ".64";
	} elsif ($s == 6) {
		$ip = $RANGE . ($e + 1) . ".130";
		$range = $RANGE . ($e + 1) . ".128";
	}

	print "insert into switches (ip, sysname, switchtype) values ('$ip', 'e$e-${s}sw', 'es3024');\n";
	print "insert into placements (switch, placement) values ($i, box '(($x,$y),($xx,$yy))');\n";
	print "insert into dhcp (switch, network) values ($i, '$RANGE$c.$d/26');\n";
	$i++;
}

print "end;\n";
