#!/usr/bin/perl
use lib '../include';
use nms;
#
#

use CGI;
use GD;
use DBI;
use strict;
use warnings;

my $img = GD::Image->new('stemp-bg5.png');
my $cgi = CGI->new;

my $dbh = nms::db_connect();

my $black = $img->colorAllocate(0,0,0);
my $white = $img->colorAllocate(255,255,255);
my $green = $img->colorAllocate(0,255,0);
my $blue = $img->colorAllocate(0,0,255);

my $avrgtemp = 54;
my $mintemp = 10.0;
my $maxtemp = 80.0;

my $color = &getcolor($avrgtemp);

for (my $i = $mintemp; $i <= $maxtemp; $i++) {
	$img->line(600, 220 + $i - $mintemp, 645, 220 + $i - $mintemp, &getcolor($i));
}

$img->string(gdMediumBoldFont, 600, 200, "Freezing!$mintemp", $black);
$img->string(gdMediumBoldFont, 600, 210, "$mintemp C", $black);
$img->string(gdMediumBoldFont, 600, 220 + $maxtemp, "Too hot! $maxtemp", $black);
$img->string(gdMediumBoldFont, 600, 210 + $maxtemp, "$maxtemp C", $black);

my $px = 5;
my $py = 30;

#$img->stringUp(gdGiantFont,$px,$py - 2,"$avrgtemp",$white);
$img->filledRectangle($px - 0, $py - 17, $px + 12, $py + 5, $white);
$img->stringUp(gdLargeFont,$px - 4,$py - 1,"$avrgtemp",$blue);
$img->rectangle($px, $py, $px + 7,$py + 7,$black);
$img->filledRectangle($px + 1, $py + 1, $px + 6, $py + 6,$color);

print $cgi->header(-type=>'image/png');
print $img->png;

sub getcolor {
	my ($temp) = @_;

	my $percent = ($temp - $mintemp) / ($maxtemp - $mintemp);
	my $colorred = 255 * $percent;
	my $colorblue = 255 - $colorred;

	return $img->colorAllocate($colorred, $colorblue, 0);
}
