function init(w, h)
   width = w
   height = h

   centerx = w / 2
   centery = h / 2
   range = math.min(width, height) / 2 * 0.7
end

-- C function reference:
-- setpixel(x, y, i) sets a grayscale pixel with intensity i
-- setpixel(x, y, i, r, g, b) sets an RGB pixel
-- cleartexture() clears the entire texture

function render(time_in_millis)
   local phase = 2 * math.pi * time_in_millis / 1000
   cleartexture()

   local ball1x = centerx + math.sin(phase * 0.5) * range
   local ball1y = centery - math.cos(phase) * range

   local ball2x = centerx + math.sin(phase * 1.2) * range
   local ball2y = centery - math.cos(phase * 0.6) * range

   for y = 1, height, 1 do
      for x = 1, width, 1 do
         local dx = ball1x - x
         local dy = ball1y - y
         local val = 390000 / (dx^2 + dy^2)

         local dx = ball2x - x
         local dy = ball2y - y
         local val = val + 390000 / (dx^2 + dy^2)
         setpixel(x - 1, y - 1, val)
      end
   end

end

