	MAC START_SCROLLING_STRING
.ADDR	SET	{1}
	lda #<.ADDR
	sta scrlptr
	lda #>.ADDR
	sta scrlptr+1
	ENDM

    MAC SCROLLER_LOGIC
	;Sets up the rightmost column on the screen
	;X = offset to byte of last row to write bits to
	;    for instance, X = 31 is the lowest value allowed
	;    since that points to the rightmost byte of line 7
	;    and the font is eight pixels high
ScrollerLogic
	lda curkern
	beq ScrollerLogic_DontKern
	dec curkern
ScrollerLogic_Ret
	rts

ScrollerLogic_DontKern
	ldy curcol
	beq ScrollerLogic_NextChar

	lda (charptr),Y
	sta temp
	ldy #8
ScrollerLogic_PutPixel
	lsr temp
	lda #0
	ror
	ora pixbuf,X
	sta pixbuf,X
	dex
	dex
	dex
	dex
	dey
	bne ScrollerLogic_PutPixel

	dec curcol
	rts

ScrollerLogic_NextChar
	;stop on NUL
	ldy #0
	lda (scrlptr),Y
	beq ScrollerLogic_Ret

	;fetch next character and figure out its width and kern
	sec
	sbc #$20
	asl
	tay
	lda Font,Y
	sta charptr
	lda Font+1,Y
	sta charptr+1
	ldy #0
	lda (charptr),Y
	tay
	and #$0F
	sta curcol
	tya
	lsr
	lsr
	lsr
	lsr
	sta curkern

	;advance pointer
	inc scrlptr
	bne ScrollerLogic
	inc scrlptr+1
	jmp ScrollerLogic
    ENDM
