const char* sound_render_source = 
"out vec4 cl;"
"float t=(gl_FragCoord.s+time*4096)/44100.0;"
"float sample_pos=t*"TIMERES";"
"float kick(){"
"vec4 x=cg(t,"KICK");"
"if (x.x<1) return 0;"
"float u=t-x.y;"
"float v=cos(pow(1-u*4,3)*100);"
"float m=bc(0.3,u/x.z*pi2)*-0.5+0.5;"
"return v*m*0.7;"
"}"
"float kosh(){"
"vec4 x=cg(t,"KOSH");"
"if (x.x<1) return 0;"
"float u=t-x.y;"
"float v=rand(vec2(u,u));"
"float m=bc(0.1,u/x.z*pi2)*-0.5+0.5;"
"return v*m*0.3;"
"}"
"void main(){"
"float t=(gl_FragCoord.s/4096+time);"
"float f=0;"
"for (int i=0;i<10;++i){"
"f+= texture2DRect(tex,vec2((t*4096)/44100*"TIMERES",i)).y;"
"}"
"vec4 k=texture2DRect(tex,vec2((t*4096)/44100*"TIMERES",0));"
"cl=(vec4(kick()+kosh())*0.5+0.5);"
"}"
;

const char* sound_source = 
"in Fragment{"
"vec4 pos;"
"}frag;"
"out vec4 cl;"
"void main(){"
"cl=frag.pos;"
"}"
;

const char* display_source = 
"out vec4 color;"
"void main(){"
"vec2 coord=gl_FragCoord.st;"
"color=texture2DRect(tex,coord*"SCALE");"
"}"
;

const char* filter_source = 
"float w(float x){"
"return (pow(2.718281828,-(x*x)))/7.3;"
"}"
"out vec4 color;"
"void main(){"
"vec2 coord=gl_FragCoord.st;"
"vec2 m;"
"if (textureSize(tex).x == " FB_W ") m=vec2(1,0);"
"else m=vec2(0,1);"
"coord*=m*3+1;"
"float x=-1.625;"
"for (int i=-8;i<8;++i){"
"color+= w(x)*texture2DRect(tex,coord+vec2(i,i)*m);"
"x+= 0.25;"
"}"
"}"
;

const char* sound_geom_source = 
"layout(points) in;"
"layout(line_strip,max_vertices=4) out;"
"out Fragment{"
"vec4 pos;"
"}frag;"
"void note(float ch,float pos,float l,float f){"
"vec4 v=vec4(pos,ch,0,1)*vec4(2.0/"RUNTIME",2.0/"CHANNELS",0,1)-vec4(1,0.95,0,0);"
"gl_Position=v;"
"frag.pos=vec4(1,pos,l,f);"
"EmitVertex();"
"gl_Position=v+vec4(l*2/"RUNTIME",0,0,0);"
"frag.pos=vec4(1,pos,l,f);"
"EmitVertex();"
"}"
"void kick(int id,float off,float w){"
"note("KICK",off+id*w,0.25,0);"
"}"
"void kosh(int id){"
"note("KOSH",id*0.5+0.3,0.1,0);"
"}"
"void main(){"
"int id=int(gl_in[0].gl_Position.x);"
"if (id<30){"
"kick(id,0,0.5);"
"return;"
"}"
"if (id<90){"
"kick(id,15,0.25);"
"return;"
"}"
"if (id<120){"
"kosh(id-60);"
"return;"
"}"
"if (id<150){"
"kick(id,15,1);"
"return;"
"}"
"}"
;

const char* transform_source = 
"out Vertex{"
"vec3 p1;"
"vec3 p2;"
"vec3 cl;"
"float size;"
"float cull;"
"}vx;"
"vec3 tr(vec4 p){"
"float r=length(p);"
"float i=acos(p.z/r)*0.8;"
"float a=atan(p.x,p.y);"
"return vec3(sin(a)*i,cos(a)*i,pow(r/5000.0,0.25));"
"}"
"vec3 la(float p){"
"return vec3(bc(0,p*0.5+time*10),bs(1,p*0.5+time*sin(time*10))*2,0);"
"}"
"int chars[17]=int[](0,630678,988959,630681,139810,432264,611161,987409,629241,630201,432534,71575,628631,1019678,139823,432537,305561);"
"int gr1[3]=int[](3,2,4);"
"int gr2[17]=int[](4,9,13,14,1,9,13,13,4,0,10,9,0,6,4,16,1);"
"int gr3[14]=int[](13,1,8,10,4,9,0,3,1,13,6,2,7,7);"
"int gr4[23]=int[](10,12,1,16,1,14,6,4,9,0,10,16,1,14,0,3,1,15,13,6,10,5,1);"
"int gr5[5]=int[](14,15,8,11,13);"
"int gr6[8]=int[](5,1,0,11,10,9,4,14);"
"vec3 le(int z,int i,int w){"
"int word=gl_VertexID/20;"
"int dot=gl_VertexID%20;"
"int x=dot%4;"
"int y=dot/4;"
"int l=chars[z];"
"vx.cull=1;"
"if (bool(l & (1<<dot))) vx.cull=0;"
"return vec3(i*5+x-w*2.5,y-3,0)*0.07;"
"}"
"vec3 rand3(float x){"
"return vec3(rand(vec2(x,0)),rand(vec2(0,x)),rand(vec2(x,x)));"
"}"
"vec3 tb(vec3 p,float t){"
"mat4 m=mat4(cos(t),0,sin(t),0,0,1,0,0,-sin(t),0,cos(t),0,0,0,0,1)*"
"mat4(1000,0,0,0,0,-1000*"ASPECT",0,0,0,0,1000,1000,0,0,0,1);"
"return tr(vec4(p,1)*m);"
"}"
"vec3 an(float p,float t){"
"vec3 j=vec3(0);"
"vx.cull=0;"
"int i=gl_VertexID/20;"
"float m=1;"
"float tp=t*pi;"
"float e=0;"
"if (tp>47) m=0.5;"
"if (tp>72) m=4;"
"if (tp>95) e=(tp-90)*0.2+1;"
"if (tp>=0&&i<3&&tp<20){"
"j=le(gr1[(i-0)%3],(i-0)%3,3);"
"j+= vec3(0,0.1,4-t-bc(1,tp*4)*0.2);"
"vx.cl=vec3(1);"
"vx.size=0.1;"
"return tb(j,0);"
"}"
"if (i>=3&&i<20){"
"j=le(gr2[(i-3)%17],(i-3)%17,17);"
"j+= vec3(10-t-bc(1,tp*4)*0.2,-0.2,0);"
"vx.cl=vec3(1,0,0);"
"vx.size=0.1;"
"return tb(j,0);"
"}"
"if (i>=20&&i<34){"
"j=le(gr3[(i-20)%14],(i-20)%14,14);"
"j+= vec3(15-floor(t),0.2,0);"
"vx.cl=vec3(0,1,0);"
"vx.size=0.1;"
"return tb(j,0);"
"}"
"if (i>=34&&i<57){"
"j=le(gr4[(i-34)%23],(i-34)%23,23);"
"j+= vec3(25-t,sin((j.x+t)*2)*0.2,bc(1,tp*2)+2);"
"vx.cl=vec3(1,0,1);"
"vx.size=0.1;"
"return tb(j,t*0.1*e);"
"}"
"if (i>=57&&i<62){"
"j=le(gr5[(i-57)%5],(i-57)%5,5);"
"j+= vec3(bs(200,t*pi*0.5),bc(200,t*pi),bs(1,t*pi*4*m)*2+2);"
"vx.cl=vec3(1,0,1);"
"vx.size=0.05*m;"
"return tb(j,0);"
"}"
"if (i>=62&&i<70){"
"j=le(gr6[(i-62)%8],(i-62)%8,8);"
"j+= vec3(bc(1,t*2),bs(1,t*2),0);"
"vx.cl=vec3(2,2,0);"
"vx.size=0.05;"
"return tb(j,0);"
"}"
"if (e>0){"
"float x=(abs(p-1)*10);"
"j=vec3(sin(x),cos(x),bc(1,e+x)*sin(e*2.2+x));"
"vx.cl=abs(j);"
"vx.size=0.05;"
"return tb(j,e);"
"}"
"vx.cull=1;"
"return tb(j,0);"
"}"
"void main(){"
"float p=gl_VertexID/"POINTS"*pi2;"
"vx.p1=an(p,time);"
"vx.p2=an(p,time+1.0/60.0);"
"}"
;

const char* bound_source = 
"layout(points) in;"
"layout(triangle_strip,max_vertices=4) out;"
"in Vertex{"
"vec3 p1;"
"vec3 p2;"
"vec3 cl;"
"float size;"
"float cull;"
"}vx[];"
"out Fragment{"
"vec3 p1;"
"vec3 p2;"
"vec3 cl;"
"float size;"
"}frag;"
"void main(){"
"if (vx[0].cull>0) return;"
"vec4 p1=vec4(vx[0].p1,1.0);"
"vec4 p2=vec4(vx[0].p2,1.0);"
"vec4 d=vec4(normalize(p2.xy-p1.xy),0,0);"
"if (distance(p2.xy,p1.xy)<0.0001) d=vec4(1,0,0,0);"
"vec4 n=vec4(-d.y,d.x,0,0);"
"float size=vx[0].size;"
"float z1=distance(p1.z,fo.x)*fo.y+size*(1.0-p1.z);"
"float z2=distance(p2.z,fo.x)*fo.y+size*(1.0-p2.z);"
"frag.p1=p1.xyz*vec3("ASPECT",1,1);"
"frag.p2=p2.xyz*vec3("ASPECT",1,1);"
"frag.cl=vx[0].cl;"
"frag.size=size;"
"gl_Position=p1-n*z1-d*z1;"
"EmitVertex();"
"gl_Position=p1+n*z1-d*z1;"
"EmitVertex();"
"gl_Position=p2-n*z2+d*z2;"
"EmitVertex();"
"gl_Position=p2+n*z2+d*z2;"
"EmitVertex();"
"}"
;

const char* sample_source = 
"in Fragment{"
"vec3 p1;"
"vec3 p2;"
"vec3 cl;"
"float size;"
"}frag;"
"out vec4 cl;"
"void main(){"
"vec2 xy=(gl_FragCoord.xy/"FB"*2-1)*vec2("ASPECT",1);"
"float t=rand(xy+time);"
"float a=6.3*rand(xy*1.1+time);"
"float r=rand(xy*1.2+time);"
"vec2 lens=vec2(sin(a)*sqrt(r),cos(a)*sqrt(r));"
"vec3 pos=mix(frag.p1,frag.p2,t);"
"vec2 m=pos.st-xy+lens*distance(pos.z,fo.x)*fo.y;"
"float d=length(m);"
"if (d<frag.size*(1.0-pos.z)){"
"cl=vec4(frag.cl,1);"
"gl_FragDepth=clamp(pos.z,0.0,0.99);"
"}else{"
"gl_FragDepth=1.95;"
"cl=vec4(0.05);"
"}"
"}"
;

const char* common_source = 
"#version 150\n"
"#extension GL_ARB_texture_rectangle : enable\n"
"uniform sampler2DRect tex;"
"uniform float time;"
"vec2 fo=vec2(0.7,0.3);"
"float rand(vec2 co){"
"return fract(sin(dot(co.xy,vec2(12.9898,78.233)))*43758.5453);"
"}"
"float bc(float s,float x){"
"return cos(x)/(s+abs(cos(x)))*(1+s);"
"}"
"float bs(float s,float x){"
"return sin(x)/(s+abs(sin(x)))*(1+s);"
"}"
"vec4 cg(float t,float i){"
"return texture2DRect(tex,vec2(t*"TIMERES",i));"
"}"
"float pi=acos(-1.0);"
"float pi2=pi*2;"
;

const char* id_source = 
"void main(){"
"gl_Position=vec4(gl_VertexID,0,0,1);"
"}"
;

const char* quad_source = 
"float[4] y=float[](1,1,-1,-1);"
"float[4] x=float[](1,-1,1,-1);"
"void main(){"
"gl_Position=vec4(x[gl_VertexID],y[gl_VertexID],0,1);"
"}"
;

