#include <dlfcn.h>

#include "linker.h"

int (*mSDL_Init)(Uint32 flags);
SDL_Surface * (*mSDL_SetVideoMode)(int width, int height, int bpp, Uint32 flags);
void (*mSDL_Quit)();
void (*mSDL_WM_SetCaption)(const char *title, const char *icon);
int (*mSDL_OpenAudio)(SDL_AudioSpec *desired, SDL_AudioSpec *obtained);
int (*mSDL_ShowCursor)(int toggle);
void (*mSDL_PauseAudio)(int pause_on);
int (*mSDL_PollEvent)(SDL_Event *event);
Uint32 (*mSDL_GetTicks)(void);
void (*mSDL_GL_SwapBuffers)(void);

const char *sdlNames = "SDL_Init\0"
  "SDL_SetVideoMode\0"
  "SDL_Quit\0"
  "SDL_WM_SetCaption\0"
  "SDL_OpenAudio\0"
  "SDL_ShowCursor\0"
  "SDL_PauseAudio\0"
  "SDL_PollEvent\0"
  "SDL_GetTicks\0"
  "SDL_GL_SwapBuffers\0";

void** sdlPointers[] = {(void*)&mSDL_Init,
			(void*)&mSDL_SetVideoMode,
			(void*)&mSDL_Quit,
			(void*)&mSDL_WM_SetCaption,
			(void*)&mSDL_OpenAudio,
			(void*)&mSDL_ShowCursor,
			(void*)&mSDL_PauseAudio,
			(void*)&mSDL_PollEvent,
			(void*)&mSDL_GetTicks,
			(void*)&mSDL_GL_SwapBuffers};

void link() {
  printf("Linking\n");
  void *sdl = dlopen("libSDL.so", RTLD_NOW);
  
  const char *pos = sdlNames;
  int i = 0;
  while (*pos) {
    *sdlPointers[i] = dlsym(sdl, pos);
    while (*pos) ++pos;
    ++pos;
  }
}
