import QtQuick 2.0
import QtGraphicalEffects 1.0

Item
{
	property string text
	property string color : "#D8D8D8"
	property string highlight: "white"

	property int pixelSize: 100
	property int letterSpacing: -10

	id: item
	width: childrenRect.width
	height: childrenRect.height

	Text
	{
		id: text
		color: item.highlight
		text: item.text

		font
		{
			pixelSize: item.pixelSize
			family: "anorexia.se"
			letterSpacing: item.letterSpacing
		}

		Text
		{
			color: item.color
			anchors
			{
				fill: parent
				topMargin: (item.pixelSize / 100) * 2
			}

			text: item.text
			font: text.font
		}
	}

	DropShadow
	{
		anchors.fill: text
		radius: 10
		samples: 16
		color: "black"
		source: text
	}
}
