import QtQuick 2.0
import Dextros.States 1.0

import ".."

DeathState
{
	id: state
	anchors.fill: parent

	Rectangle
	{
		id: overlay
		anchors
		{
			fill: parent
		}

		color: "#AA000000"
		opacity: 0

		states: State
		{
			when: overlay.visible

			PropertyChanges { target: overlay; opacity: 1 }
		}

		transitions: Transition
		{
			PropertyAnimation { property: "opacity"; duration: 200; }
		}

		Column
		{
			id: textGameOver

			anchors
			{
				centerIn: parent
				verticalCenterOffset: -100
			}

			states: State
			{
				when: textGameOver.visible

				PropertyChanges { target: textGameOver; anchors.verticalCenterOffset: -70 }
			}

			transitions: Transition
			{
				PropertyAnimation { property: "anchors.verticalCenterOffset"; duration: 200; }
			}

			Image
			{
				anchors
				{
					horizontalCenter: parent.horizontalCenter
				}

				source: "image://winner/0"
				cache: false
				scale: state.scale
			}

			StyledText
			{
				text: state.message
			}
		}

//		Column
//		{
//			id: column
//			spacing: 20

//			anchors
//			{
//				centerIn: parent
//				horizontalCenterOffset: -50
//				verticalCenterOffset: 100
//			}

//			states: State
//			{
//				when: column.visible

//				PropertyChanges { target: column; anchors.horizontalCenterOffset: 0 }
//			}

//			transitions: Transition
//			{
//				PropertyAnimation { property: "anchors.horizontalCenterOffset"; duration: 200; }
//			}

//			StyledText
//			{
//				highlight: "#F83800"
//				color: "#A81000"
//				text: "Try again"
//				pixelSize: 60
//				letterSpacing: -5
//				anchors
//				{
//					horizontalCenter: parent.horizontalCenter
//				}
//			}

//			StyledText
//			{
//				text: "Give up"
//				pixelSize: 60
//				letterSpacing: -5
//				anchors
//				{
//					horizontalCenter: parent.horizontalCenter
//				}
//			}
//		}
	}
}
