import QtQuick 2.0
import Dextros.States 1.0

import ".."

GameState
{
	id: state
	anchors.fill: parent

//	Text
//	{
//		anchors
//		{
//			horizontalCenter: parent.horizontalCenter
//			top: parent.top
//			margins: 32
//		}

//		color: "white"
//		text: state.fps
//	}

	StyledText
	{
		id: text
		anchors.centerIn: parent
		text: state.countdown > 0 ?
			state.countdown : "GO"
		visible: state.countdown > -1 && state.countdown <= 3

		Behavior on text
		{
			SequentialAnimation
			{
				NumberAnimation { target: text; property: "scale"; to: 1; duration: 0 }
				NumberAnimation { target: text; property: "opacity"; to: 1; duration: 100 }

				ParallelAnimation
				{
					NumberAnimation { target: text; property: "scale"; to: 1.5; duration: 500 }
					NumberAnimation { target: text; property: "opacity"; to: 0; duration: 500 }
				}
			}
		}
	}

	ItemIndicator
	{
		anchors
		{
			left: parent.left
			top: parent.top
			margins: 32
		}

		player: state.player1
		scale: state.scale
		transformOrigin: Item.TopLeft
	}

	ItemIndicator
	{
		anchors
		{
			right: parent.right
			top: parent.top
			margins: 32
		}

		player: state.player2
		scale: state.scale
		transformOrigin: Item.TopRight
	}

//	ScoreIndicator
//	{
//		anchors
//		{
//			left: parent.left
//			bottom: parent.bottom
//			margins: 32
//		}

//		player: state.player1
//	}

//	ScoreIndicator
//	{
//		anchors
//		{
//			right: parent.right
//			bottom: parent.bottom
//			margins: 32
//		}

//		player: state.player2
//	}
}
