# -*- coding: cp1252 -*-

from Tkinter import *
from ttk import Frame, Button, Style, Entry, Label, Scale
import tkMessageBox as box
import server

class ServerGUI( Frame ):
  
	def __init__(self, parent):
		Frame.__init__(self, parent)

		self.parent = parent
		self.maxPlayers = IntVar()
		self.maxPlayers.set( 6 )
		self.roundTimeMin = IntVar()
		self.roundTimeMin.set( 3 )

		self.initUI()

	def initUI(self):

		self.parent.title("Shadowfiend Server 1.0")
		self.style = Style()
		self.style.theme_use("default")

		frame = Frame( self, relief=RAISED, borderwidth=1 )
		frame.pack( fill=BOTH, expand=1 )

		portFrame = Frame( frame )
		portFrame.pack( side=TOP, pady=5 )
		portLabel = Label(portFrame, text="Server Port: ")
		portLabel.pack( side=LEFT)
		self.port = Entry( portFrame, width=10)
		self.port.pack(side=LEFT)

		maxPlayerFrame = Frame( frame )
		maxPlayerFrame.pack( side=TOP, pady=5 )
		maxPlayerText = Label( maxPlayerFrame, text="Max Players: " )
		maxPlayerText.pack( side=LEFT)
		maxPlayer = Scale( maxPlayerFrame, from_=2, to=8, command=self.onPlayerScale )
		maxPlayer.set( self.maxPlayers.get() )
		maxPlayer.pack( side=LEFT )
		maxPlayerLabel = Label( maxPlayerFrame, textvariable = self.maxPlayers )
		maxPlayerLabel.pack( side=LEFT )

		roundTimeFrame = Frame( frame )
		roundTimeFrame.pack( side=TOP, pady=5 )
		roundTimeText = Label(roundTimeFrame, text="Round Time: ")
		roundTimeText.pack( side=LEFT)
		roundTime = Scale( roundTimeFrame, from_=3, to=30, command=self.onTimeScale )
		roundTime.set( self.roundTimeMin.get() )
		roundTime.pack(side=LEFT)
		roundTimeLabel = Label( roundTimeFrame, textvariable = self.roundTimeMin )
		roundTimeLabel.pack( side=LEFT )

		self.pack( fill=BOTH, expand=1 )

		quitButton = Button( self, text="Quit", command=self.parent.destroy )
		quitButton.pack( side=RIGHT, padx=5 )
		startButton = Button( self, text="Start Server", command=self.start )
		startButton.pack( side=RIGHT, padx=5, pady=5 )

	def onPlayerScale( self, value ):
		self.maxPlayers.set( int( float( value ) ) )

	def onTimeScale( self, value ):
		self.roundTimeMin.set( int( float( value ) ) )

	def start( self ):
		try:
			validatedPort = int( self.port.get() )
			if( validatedPort < 0 and validatedPort > 65535 ):
				box.showerror("Error", "Invalid port number!")
				return
		except:
			box.showerror("Error", "Invalid port number!")
			return
		self.startServer( validatedPort, self.maxPlayers.get(), self.maxPlayers.get() )

	def startServer( self, port, maxPlayers, gameTime ):
		server.Server( port, maxPlayers, gameTime )

def main():

	root = Tk()
	root.geometry( "300x130" )
	app = ServerGUI( root )
	root.mainloop()  


if __name__ == '__main__':
	main()  