/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ArgumentAssignmentNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.asmnode.output.SideEffectOnlyOutput;
import cml.kickass.directives.Label;
import cml.kickass.directives.LabelConnector;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.plugins.impl.PluginEngine;
import cml.kickass.plugins.impl.PluginValue;
import cml.kickass.plugins.interf.IMacro;
import cml.kickass.plugins.interf.IValue;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.values.NameSpaceValue;
import cml.kickass.values.Value;
import cml.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;

public class MacroExecution
extends AsmDirective
implements LabelConnector {
    private static Log log = new Log("");
    private String name;
    private List<ExprNode> argumentExprs;
    private String nameSpaceId;

    public MacroExecution(String string, List<ExprNode> list, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.argumentExprs = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.nameSpaceId = label.getName();
        return true;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) throws AsmException {
        ExecutableDirectives executableDirectives = evaluationState.getCurrentScope().getMacros().get(this.name);
        if (executableDirectives != null) {
            return this.preParseStandardMacro(evaluationState, executableDirectives);
        }
        IMacro iMacro = evaluationState.getCurrentScope().getMacroPlugins().get(this.name);
        if (iMacro != null) {
            return new PluginMacroExecution(iMacro, this.argumentExprs, this.debug);
        }
        throw new AsmError("Macro command  '" + this.name + "' not defined", this.debug);
    }

    private AsmNode preParseStandardMacro(EvaluationState evaluationState, ExecutableDirectives executableDirectives) throws AsmException {
        List<String> list = executableDirectives.getArgumentNames();
        if (list.size() != this.argumentExprs.size()) {
            throw new AsmError("Invalid number of arguments for macro", this.debug);
        }
        NameSpaceValue nameSpaceValue = this.nameSpaceId == null ? null : new NameSpaceValue(this.nameSpaceId, true);
        AsmNode asmNode = new AsmNodeList(executableDirectives.getCopyOfDirectives());
        asmNode = new ArgumentAssignmentNode(executableDirectives.getArgumentNames(), this.argumentExprs, asmNode, null, nameSpaceValue, this.debug);
        return asmNode.preParse(evaluationState);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("MacroExec", this.debug, this.name, "" + this.nameSpaceId, this.argumentExprs);
        return nodeTreeBuilder;
    }

    private static class PluginMacroExecution
    extends AsmDirective {
        private IMacro macro;
        private List<ExprNode> argumentExprs;

        public PluginMacroExecution(IMacro iMacro, List<ExprNode> list, DebugInfo debugInfo) {
            super(debugInfo);
            this.macro = iMacro;
            this.argumentExprs = list;
        }

        @Override
        public AsmNode copy() {
            return this;
        }

        @Override
        public AsmNode parse(EvaluationState evaluationState) {
            Object object;
            Object object2;
            evaluationState.clearFunctionSideOutput();
            IValue[] iValueArray = new IValue[this.argumentExprs.size()];
            boolean bl = false;
            for (int i = 0; i < iValueArray.length; ++i) {
                object2 = this.argumentExprs.get(i);
                object = this.argumentExprs.get(i).evaluate(evaluationState).deReference();
                bl |= ((Value)object).isInvalid();
                iValueArray[i] = new PluginValue((Value)object, ((ExprNode)object2).getDebugInfo());
            }
            if (bl) {
                return this;
            }
            PluginEngine pluginEngine = new PluginEngine(evaluationState, this.debug);
            try {
                object2 = this.macro.execute(iValueArray, pluginEngine);
            }
            catch (Throwable throwable) {
                if (throwable instanceof AsmError) {
                    throw (AsmError)throwable;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                throwable.printStackTrace(printStream);
                log.println(byteArrayOutputStream.toString());
                throw new AsmError("Exception while executing plugin macro", this.debug);
            }
            if (object2 != null) {
                evaluationState.increaseMemoryPosition(((Object)object2).length);
            }
            object = evaluationState.getFunctionSideOutput();
            return object2 == null ? new SideEffectOnlyOutput((FunctionSideOutput)object) : new ByteOutput((byte[])object2, (FunctionSideOutput)object);
        }

        @Override
        public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
            nodeTreeBuilder.addNode("PluginMacroExec", this.debug, this.macro.getName(), this.argumentExprs);
            return nodeTreeBuilder;
        }
    }
}

