/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class QuestionIf
extends ExprNode {
    private ExprNode conditionExpr;
    private ExprNode trueExpr;
    private ExprNode falseExpr;

    public QuestionIf(ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3, DebugInfo debugInfo) {
        super(debugInfo);
        this.conditionExpr = exprNode;
        this.trueExpr = exprNode2;
        this.falseExpr = exprNode3;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.conditionExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmError("The condition must be able to evaluate in first parse", this.debug);
        }
        return value.getBoolean(this.debug) ? this.trueExpr.evaluate(evaluationState) : this.falseExpr.evaluate(evaluationState);
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("condition:", this.conditionExpr);
        exprTreeBuilder.addNode("true:", this.trueExpr);
        exprTreeBuilder.addNode("false:", this.falseExpr);
        return exprTreeBuilder;
    }
}

