/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.state.scope.Scope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.NameSpaceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.log.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ViceSymbolFile {
    private static Log log = new Log("ViceSymbolFile");
    private Scope rootScope;

    public ViceSymbolFile(Scope scope) {
        this.rootScope = scope;
    }

    public void writeFile(String string) {
        try {
            Map<String, Integer> map = this.initMultiSymbolTable(this.rootScope);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            this.writeFile(this.rootScope, bufferedWriter, map);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            log.error("IO error while writing vice symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            log.error("Internal error while writing vice symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private Map<String, Integer> initMultiSymbolTable(Scope scope) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.countLabels(scope, hashMap);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            hashMap2.put((String)entry.getKey(), new Integer(1));
        }
        return hashMap2;
    }

    private void countLabels(Scope scope, Map<String, Integer> map) {
        for (Map.Entry object : scope.getSymbols().getLocalDefinedEntities().entrySet()) {
            String string = object.getKey();
            SymbolScopeValue symbolScopeValue = (SymbolScopeValue)object.getValue();
            if (!(symbolScopeValue instanceof LabelReferenceValue)) continue;
            Integer n = map.get(string);
            if (n == null) {
                n = 0;
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
            map.put(string, n);
        }
        for (Scope scope2 : scope.getChildren()) {
            this.countLabels(scope2, map);
        }
    }

    private void writeFile(Scope scope, Writer writer, Map<String, Integer> map) throws Exception {
        for (Map.Entry object : scope.getSymbols().getLocalDefinedEntities().entrySet()) {
            String string = object.getKey();
            try {
                SymbolScopeValue symbolScopeValue = (SymbolScopeValue)object.getValue();
                if (!(symbolScopeValue instanceof LabelReferenceValue) || symbolScopeValue instanceof NameSpaceValue && !((NameSpaceValue)symbolScopeValue).isAlsoLabel()) continue;
                String string2 = string;
                Integer n = map.get(string);
                if (n != null) {
                    string2 = string2 + "__" + n;
                    map.put(string, n + 1);
                }
                String string3 = Integer.toHexString(((SymbolScopeValue)scope.getSymbols().get(string)).getInt(null));
                writer.write("al C:" + string3 + " ." + string2 + "\n");
            }
            catch (Exception exception) {
                throw new Exception("Error while writing symbol " + string + " : " + exception.getMessage());
            }
        }
        for (Scope scope2 : scope.getChildren()) {
            this.writeFile(scope2, writer, map);
        }
    }
}

