/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.CharToPetsciiConverter;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class CharValue
extends NumberValue {
    public static Value invalid = new CharValue();
    private char c;
    static FunctionTable functions = new StdFunctionTable((StdFunctionTable)NumberValue.functions);

    private CharValue() {
        super(Double.NaN);
        this.setInvalid();
    }

    public CharValue(char c) {
        super(Byte.valueOf(CharToPetsciiConverter.convert(c, true)).doubleValue());
        this.c = c;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid Char" : "Char";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == Value.RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Char>>";
            }
            return String.valueOf(this.c);
        }
        return super.getRepresentation(n);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                Double d = (Double)valueArray[1].getRepresentation(Value.RP_DOUBLEVALUE);
                if (d != null) {
                    return BooleanValue.get(valueArray[0].getDouble(debugInfo) == d.doubleValue());
                }
                String string = valueArray[0].getString(debugInfo);
                String string2 = valueArray[1].getString(debugInfo);
                return BooleanValue.get(string.equals(string2));
            }
        }, true, null);
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                String string;
                Double d = valueArray[1].getDouble(debugInfo);
                if (d != null) {
                    return BooleanValue.get(valueArray[0].getDouble(debugInfo) != d.doubleValue());
                }
                String string2 = valueArray[0].getString(debugInfo);
                return BooleanValue.get(!string2.equals(string = valueArray[1].getString(debugInfo)));
            }
        }, true, null);
    }
}

