/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.ListValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructValue
extends LockableValue {
    public static StructValue invalid = new StructValue();
    private String structName;
    private List<String> variableNames;
    private Map<String, Value> variables = new HashMap<String, Value>();
    private Value noOfFields;
    static FunctionTable functions = new StdFunctionTable(StructValue.getStandardFunctions());
    private boolean checkingInvalidContent = false;

    private StructValue() {
        this.setInvalid();
        this.structName = "Invalid";
    }

    public StructValue(String string, List<String> list, Value[] valueArray) {
        this.structName = string;
        this.variableNames = list;
        this.noOfFields = new NumberValue(list.size());
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            NullValue nullValue = valueArray == null ? NullValue.instance : valueArray[i];
            VariableReferenceValue variableReferenceValue = new VariableReferenceValue(nullValue);
            this.variables.put(string2, variableReferenceValue);
        }
    }

    @Override
    public boolean hasInvalidContent() {
        if (this.checkingInvalidContent) {
            return false;
        }
        this.checkingInvalidContent = true;
        boolean bl = false;
        for (Value value : this.variables.values()) {
            if (!value.isInvalidOrInvalidContent()) continue;
            bl = true;
            break;
        }
        this.checkingInvalidContent = false;
        return bl;
    }

    @Override
    public String getType() {
        return "struct";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Struct>>";
            }
            return this.structName + "-struct";
        }
        return null;
    }

    @Override
    public Value localGetVariable(String string, DebugInfo debugInfo) throws AsmException {
        if (this.isInvalid()) {
            return InvalidValue.instance;
        }
        return this.variables.get(string);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.variables.values()) {
            value.lock(debugInfo);
        }
    }

    static {
        functions.add(new StructValueFunction("getStructName", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, DebugInfo debugInfo, Value ... valueArray) {
                return new StringValue(structValue.structName);
            }
        });
        functions.add(new StructValueFunction("get", 2, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, DebugInfo debugInfo, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String string = this.getFieldName(valueArray[1], structValue, debugInfo);
                Value value = (Value)structValue.variables.get(string);
                return value;
            }
        });
        functions.add(new StructValueFunction("set", 3, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, DebugInfo debugInfo, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String string = this.getFieldName(valueArray[1], structValue, debugInfo);
                Value value = valueArray[2];
                structValue.variables.put(string, value);
                return NullValue.instance;
            }
        });
        functions.add(new StructValueFunction("getFieldNames", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, DebugInfo debugInfo, Value ... valueArray) {
                ListValue listValue = new ListValue(0);
                for (String string : structValue.variableNames) {
                    listValue.add((Value)new StringValue(string));
                }
                return listValue;
            }
        });
        functions.add(new StructValueFunction("getNoOfFields", 1, (Value)InvalidValue.instance){

            @Override
            protected Value f(StructValue structValue, DebugInfo debugInfo, Value ... valueArray) {
                return structValue.noOfFields;
            }
        });
    }

    private static abstract class StructValueFunction
    extends Function {
        public StructValueFunction(String string, int n, Value value) {
            super(string, n, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            StructValue structValue = (StructValue)valueArray[0];
            if (structValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f(structValue, debugInfo, valueArray);
        }

        protected abstract Value f(StructValue var1, DebugInfo var2, Value ... var3);

        String getFieldName(Value value, StructValue structValue, DebugInfo debugInfo) {
            if (value.hasRepresentation(Value.RP_DOUBLEVALUE)) {
                int n = value.getInt(debugInfo);
                if (n < 0 || structValue.variableNames.size() <= n) {
                    throw new AsmError("Invalid name index: " + n, debugInfo);
                }
                return (String)structValue.variableNames.get(n);
            }
            String string = value.getString(debugInfo);
            if (!structValue.variableNames.contains(string)) {
                throw new AsmError("Unknown field name: " + string, debugInfo);
            }
            return string;
        }
    }
}

