

/**
 * a HUD container and child items
 */

game.HUD = game.HUD || {};


game.HUD.Container = me.ObjectContainer.extend({

	init: function() {
		// call the constructor
		this.parent();
		
		// persistent across level change
		this.isPersistent = true;
		
		// non collidable
		this.collidable = false;
		
		// make sure our object is always draw first
		this.z = Infinity;

		// give a name
		this.name = "HUD";
		
		// add our child score object at the top left corner
		this.addChild(new game.HUD.ScoreItem(me.game.viewport.width - 220, me.game.viewport.height - 40));
		this.addChild(new game.HUD.DfoxFace(me.game.viewport.width / 2, me.game.viewport.height - 20, 4));
		this.addChild(new game.HUD.Countdown(20, me.game.viewport.height - 40));
	}
});


/** 
 * a basic HUD item to display score
 */
game.HUD.ScoreItem = me.Renderable.extend({	
	/** 
	 * constructor
	 */
	init: function(x, y) {
		
		// call the parent constructor 
		// (size does not matter here)
		this.parent(new me.Vector2d(x, y), 10, 10); 
		
		// local copy of the global score
		this.score = -1;

		this.font = new me.BitmapFont("32x32_font", 32);
		this.font.set("right");
		
		this.healthbar = me.loader.getImage("healthbar");
		
		// make sure we use screen coordinates
		this.floating = true;
	},

	/**
	 * update function
	 */
	update : function () {
		// we don't do anything fancy here, so just
		// return true if the score has been updated
		if (this.score !== game.data.nstickers) {	
			this.score = game.data.nstickers;
			return true;
		}
		return false;
	},

	/**
	 * draw the score
	 */
	draw : function (context) {
		this.font.draw(context, game.data.nstickers, this.pos.x, this.pos.y);
		
		if (game.data.nstickers < game.data.maxstickers) {
			w = this.healthbar.width * (1 - (game.data.nstickers / game.data.maxstickers));
			h = this.healthbar.height;
			context.drawImage(this.healthbar, 0, 0, w, h, this.pos.x + 8, this.pos.y + 8, w, h);
		}
	}

});

/** 
 * a basic HUD item to display score
 */
game.HUD.Countdown = me.Renderable.extend({	
	/** 
	 * constructor
	 */
	init: function(x, y) {
		
		// call the parent constructor 
		// (size does not matter here)
		this.parent(new me.Vector2d(x, y), 10, 10); 
		
		// local copy of the global score
		this.score = -1;

		this.font = new me.BitmapFont("32x32_font", 32);
		this.font.set("left");
		
		this.healthbar = me.loader.getImage("healthbar");
		
		// make sure we use screen coordinates
		this.floating = true;
	},

	/**
	 * update function
	 */
	update : function () {
		// we don't do anything fancy here, so just
		// return true if the score has been updated
		if (this.score !== game.data.countdown) {	
			this.score = game.data.countdown;
			return true;
		}
		return false;
	},

	/**
	 * draw the score
	 */
	draw : function (context) {
		mins = ~~(game.data.countdown / 60);
		secs = game.data.countdown % 60;
		if (secs < 10)
			secs = "0" + secs;
		this.font.draw(context, mins + ":" + secs, this.pos.x, this.pos.y);
	}

});

/** 
 * a basic HUD item to display score
 */
game.HUD.DfoxFace = me.Renderable.extend({	
	/** 
	 * constructor
	 */
	init: function(x, y, nfaces) {
		
		// call the parent constructor 
		// (size does not matter here)
		this.parent(new me.Vector2d(0, 0), 10, 10); 
		
		// local copy of the global score
		this.score = -1;

		this.faces = me.loader.getImage("dfox_faces");
		this.faceWidth = this.faces.width / nfaces;
		this.pos.set(x - this.faceWidth / 2, y - this.faces.height);
		
		// make sure we use screen coordinates
		this.floating = true;
	},

	/**
	 * update function
	 */
	update : function () {
		// we don't do anything fancy here, so just
		// return true if the score has been updated
		if (this.score !== game.data.nstickers) {	
			this.score = game.data.nstickers;
			return true;
		}
		return false;
	},

	/**
	 * draw the score
	 */
	draw : function (context) {
		part = game.data.nstickers / game.data.maxstickers;
		idx = 0;
		if (part > 0.999)
			idx = 3;
		else if (part > 0.7)
			idx = 2;
		else if (part > 0.4)
			idx = 1;
		else
			idx = 0;
			
		context.drawImage(this.faces, idx * this.faceWidth, 0, this.faceWidth, this.faces.height, 
							this.pos.x, this.pos.y, this.faceWidth, this.faces.height);
	}

});
