game.PlayerEntity = me.ObjectEntity.extend({
 
    init: function(x, y, settings) {
        // call the constructor
        this.parent(x, y, settings);
		
		// set the default horizontal & vertical speed (accel vector)
        this.setVelocity(5, 5);
		
		this.StickerMap = me.game.currentLevel.getLayerByName("stickers");
		this.direction = new me.Vector2d(1, 0);
 
        // set the display to follow our position on both axis
        me.game.viewport.follow(this.pos, me.game.viewport.AXIS.BOTH);
 
    },
 	
	handleInput: function() {
	        if (me.input.isKeyPressed('left')) {
            this.renderable.angle = Math.PI;
			this.direction.set(-1, 0);
            this.vel.x -= this.accel.x * me.timer.tick;
        } else if (me.input.isKeyPressed('right')) {
            this.renderable.angle = 0;
			this.direction.set(1, 0);
            this.vel.x += this.accel.x * me.timer.tick;
        } else {
            this.vel.x = 0;
        }
        if (me.input.isKeyPressed('down')) {
            this.renderable.angle = Math.PI / 2;
			this.direction.set(0, 1);
            this.vel.y += this.accel.y * me.timer.tick;
        } else if (me.input.isKeyPressed('up')) {
            this.renderable.angle = Math.PI * 3 / 2;
			this.direction.set(0, -1);
            this.vel.y -= this.accel.y * me.timer.tick;
        } else {
            this.vel.y = 0;
        }
		
		/*
		
		stickerfoxer
		
		*/
		
		if (me.input.isKeyPressed('scrape') && !this._scrapePressed) {
			this._scrapePressed = true;
			w = this.StickerMap.tilewidth;
			h = this.StickerMap.tileheight;
			this._bounds = this.getBounds(this._bounds);
			x = this.pos.x + this._bounds.hWidth + (w * this.direction.x);
			y = this.pos.y + this._bounds.hHeight + (h * this.direction.y);
			
			//this.pos.x + w * this.direction.x, this.pos.y + h * this.direction.y
			var tile = this.StickerMap.getTile(x, y);
			
			if (tile) {
				this.StickerMap.clearTile(~~(x / w), ~~(y / h));
				me.audio.play("unstick" + ~~(Math.random() * 3 + 1));
				game.data.nstickers--;
			}			
		} else {
			this._scrapePressed = false;
		}
	},
	
    update: function(dt) {
		if (game.data.lost)
			this.vel.setZero();
		else
			this.handleInput();
	
		/* tentatively move, don't if we'd collide anywhere */
		this.pos.x += this.vel.x;
		this.pos.y += this.vel.y;
		res = me.game.world.collide(this);
		this.pos.x -= this.vel.x;
		this.pos.y -= this.vel.y;
		if (res) {
			this.vel.x = 0;
			this.vel.y = 0;
		}
		
        // check & update player movement
        this.updateMovement();
 
        // update animation if necessary
        if (this.vel.x!=0 || this.vel.y!=0) {
            // update object animation
            this.parent(dt);
            return true;
        }
		
		if (!this._prevAngle || this._prevAngle != this.renderable.angle)
			return true;
			
		this._prevAngle = this.renderable.angle;
         
        // else inform the engine we did not perform
        // any update (e.g. position, animation)
        return false;
    }
 
});

game.VisitorEntity = me.ObjectEntity.extend({
 
    init: function(x, y, settings) {
        // call the constructor
        this.parent(x, y, settings);
		
		this.collidable = true;
		this.type = me.game.ENEMY_OBJECT;
		
		this.StickableMap = me.game.currentLevel.getLayerByName("stickable");
		this.StickersMap = me.game.currentLevel.getLayerByName("stickers");
		
		this.collisionCount = 0;
		this.startPos = new me.Vector2d(this.pos.x, this.pos.y);
		
		this.stickerTileIds = [];
		var tileset = this.StickersMap.tilesets.getTilesetByGid(10);
		for (i = 0; i < 256; i++) {
			var bla = tileset.getTileProperties(i);
			if (bla && bla.isLadder) {
				console.log(i);
				this.stickerTileIds.push(i);
			}
		}
		
		// set the default horizontal & vertical speed (accel vector)
        this.setVelocity(5, 5);
    },
 
    /* -----
 
    update the player pos
 
    ------ */
	changeMovement: function() {
		rand = Math.random();
		this.vel.setZero();
		if (rand < 1 / 4) {
			this.renderable.angle = Math.PI;
			this.accel.x = -5;
			this.accel.y = 0;
		} else if (rand < 1 / 2) {
			this.renderable.angle = 0;
			this.accel.x = 5;
			this.accel.y = 0;
		} else if (rand < 3 / 4) {
			this.renderable.angle = Math.PI / 2;
			this.accel.x = 0;
			this.accel.y = 5;
		} else {
			this.renderable.angle = Math.PI * 3 / 2;
			this.accel.x = 0;
			this.accel.y = -5;
		}
	},
	
	TILE_FLAT   : 0,
	TILE_TOP    : 1,
	TILE_LEFT   : 2,
	TILE_BOTTOM : 3,
	TILE_RIGHT  : 4,
	
	dropSticker: function(tile, type) {
		var map = this.StickersMap;
		var stickerTile = map.getTile(tile.pos.x, tile.pos.y);
		//if (stickerTile)
		//	console.log("id " + stickerTile.tileId + " x " + stickerTile.pos.x + " y " + stickerTile.pos.y + " type " + type);
		if (!stickerTile || !stickerTile.tileId) {
			if (Math.random() > game.data.stickerprob)
				return;
		
			tileId = this.stickerTileIds[~~(Math.random() * this.stickerTileIds.length)];
			map.setTile(~~(tile.pos.x / map.tilewidth), ~~(tile.pos.y / map.tileheight), tileId);
			
			me.audio.play("stick" + ~~(Math.random() * 3 + 1));
			game.data.nstickers++;
			
			if (game.data.nstickers === game.data.maxstickers)
				me.state.current().lose();
		}
	},
	
	tryDropSticker: function() {
		//var b = this.getBounds(this._bounds);
		//console.log("top " + b.top + " bot " + b.bottom + " left " + b.left + " right " + b.right);
        this._bounds = this.getBounds(this._bounds);
        this.__offsetX = this._bounds.pos.x;
        this.__offsetY = this._bounds.pos.y;
        this._bounds.translateV(this.pos);

		var collision = this.StickableMap.checkCollision(this._bounds, this.vel);

		if (collision.x && collision.xtile) {
			//console.log("x " + collision.x + " y " + collision.y + " prop " + collision.xprop + " tile " + collision.xtile);
			if (collision.xprop.isSolid)
				this.dropSticker(collision.xtile, this.TILE_FLAT);
			else
				this.dropSticker(collision.xtile, (collision.x > 0) ? this.TILE_RIGHT : this.TILE_LEFT);
		} else if (collision.y && collision.ytile) {
			//console.log("x " + collision.x + " y " + collision.y + " prop " + collision.yprop + " tile " + collision.ytile);
			if (collision.yprop.isSolid)
				this.dropSticker(collision.ytile, this.TILE_FLAT);
			else
				this.dropSticker(collision.ytile, (collision.y > 0) ? this.TILE_BOTTOM : this.TILE_TOP);
		}		
	},
	
    update: function(dt) {
		if (Math.random() < 0.02)
			this.changeMovement();
			
		this.vel.x += this.accel.x;
		this.vel.y += this.accel.y;

		/* tentatively move, don't if we'd collide with anyone */
		this.pos.x += this.vel.x;
		this.pos.y += this.vel.y;
		res = me.game.world.collide(this);
		this.pos.x -= this.vel.x;
		this.pos.y -= this.vel.y;
		if (res) {
			this.changeMovement();

			this.collisionCount++;
			if (this.collisionCount > 10) {
				this.pos.copy(this.startPos);
				return true;
			}
			
			/* do nothing this time, try again next time */
			return false;
		} else {
			this.collisionCount = 0;
		}

        // check & update player movement
        this.updateMovement();
		this.tryDropSticker();
 
        // update animation if necessary
        if (this.vel.x!=0 || this.vel.y!=0) {
            // update object animation
            this.parent(dt);
            return true;
        }
         
        // else inform the engine we did not perform
        // any update (e.g. position, animation)
        return false;
    }
 
});