alias demo_plasmoire {

        if (%dm.plasmoire.c < 1) {

                ;; moire

                var %x1 $calc(($cos($calc(%dm.c / 6)).deg * 96) + 160)
                var %y1 $calc(($sin($calc(%dm.c /  9.7)).deg * 64) + 90)
                var %x2 $calc(($sin($calc(%dm.c / 7.1)).deg * 128) + 160)
                var %y2 $calc(($cos($calc(%dm.c / 8.2)).deg * 64) + 90)

                var %cnt 1

                while (%cnt <= %dm.plasmoire.tot) {

                        drawdot -nri @demo 0 $calc(0 + (%cnt * 8)) %x1 %y1 %x2 %y2

                        inc %cnt
                }

                if (%dm.plasmoire.tot < 40) {

                        dinc dm.plasmoire.tot .1
                }
        }

        else {

                ;; plasma

                drawpic -nc @dm.plasmoire.1 0 0 $qt($+($scriptdirimg\plasma\,$floor(%dm.plasmoire.plasma),-,$round(%dm.plasmoire.fcnt, 0),.bmp))

                dinc dm.plasmoire.fcnt .02

                if (%dm.plasmoire.fcnt > 19) {

                        set %dm.plasmoire.fcnt 1
                }

                drawcopy -n @dm.plasmoire.1  0  0  92  92 @dm.plasmoire.b   0   0  92  92
                drawcopy -n @dm.plasmoire.1  0  0  92  92 @dm.plasmoire.b  92   0  92  92
                drawcopy -n @dm.plasmoire.b  0  0 184  92 @dm.plasmoire.b   0  92 184  92
                drawcopy -n @dm.plasmoire.b  0  0 184 184 @dm.plasmoire.b 184   0 184 184

                var %c3  $calc((%dm.c + 16) / (%dm.bpm * 1280))

                var %zoom.x $calc(($sin(%c3).deg * 90) + 90)
                var %zoom.y $calc(($sin(%c3).deg * 55) + 55)

                drawcopy -n @dm.plasmoire.b $calc(%zoom.x / 2) $calc(%zoom.y / 2) $calc(320 - %zoom.x) $calc(180 - %zoom.y) @demo 0 0 320 180

                dinc dm.plasmoire.plasma $calc(%dm.bpm / 4)

                if (%dm.plasmoire.plasma > 5) {

                        set %dm.plasmoire.plasma 1
                }

        }

        dinc dm.plasmoire.c $calc(%dm.bpm / 4)

        if (%dm.plasmoire.c > 2) {

                set %dm.plasmoire.c 0
        }

        ;; fadeout

        if (%dm.c > 14000) {

                dinc dm.plasmoire.fade.c $calc(%dm.bpm * 9)

                if (%dm.plasmoire.fade.c > 16) {

                        set %dm.plasmoire.fade.c 16
                }

                drawrect -nrf @demo 0 0 0 0 $gettok(%dm.plasmoire.fade.tab, %dm.plasmoire.fade.c, 32) 180
        }

        ;; overlay

        if (%dm.c > 13500) {

                if (%dm.plasmoire.overlay.x < 320) {

                        dinc dm.plasmoire.overlay.x 0.075
                }
        }

        if (%dm.zoom.overlay.c >= 2) {

                set %dm.zoom.overlay.c 0
        }

        inc %dm.zoom.overlay.c

        drawpic -nct @demo 0 %dm.plasmoire.overlay.x 144 %dm.zoom.overlay. [ $+ [ %dm.zoom.overlay.c ] ]

        if (%dm.c > 15100) {

                .signal -n dmSelectPart flashtext
                halt
        }

        dmDrawFrame demo_plasmoire
}

alias dmGenPlasma {

        var %tab %dm.plasmoire.ctab. [ $+ [ $1 ] ]
        var %win @dm.plasmoire. [ $+ [ $1 ] ]

        drawrect -nrf %win 0 0 0 0 100 100

        var %c/8 $calc(%dm.plasmoire.fcnt * 10)
        var %sin8 $calc($sin(%c/8).deg * 80)
        var %cos8 $calc($cos(%c/8).deg * 96)

        var %x 0

        while (%x < 92) {

                var %cos $calc($cos($calc((%x * 4) + %c/8)).deg * %sin8)

                var %y 0

                while (%y < 92) {

                        drawrect -nrf %win $gettok(%tab, $calc((%cos + ($sin($calc((%y * 4) + %c/8)).deg * %cos8)) + 128), 32) 0 %x %y 4 4

                        inc %y 4
                }

                inc %x 4
        }

        drawsave -b16 %win $qt($+($scriptdirimg\plasma\,$1,-,%dm.plasmoire.fcnt,.bmp))
        inc %dm.plasmoire.fcnt
}