#include "filebits.h"

#include <cstdio>
#include <cassert>

extern "C" {
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <arpa/inet.h>
}

File::File(const char* name)
	{
	m_descriptor = open(name, O_RDONLY);
	if (-1 == m_descriptor)
		{
		perror("<!> file open");
		return;
		}

	struct stat fileInfo;
	fstat(m_descriptor, &fileInfo);

	m_size = fileInfo.st_size;
	m_data = (byte*) mmap(0, m_size, PROT_READ, MAP_SHARED, m_descriptor, 0);

	if (MAP_FAILED == m_data)
		{
		perror("<!> file mmap");
		close(m_descriptor);
		m_descriptor = -1;
		m_size = 0;
		}
	}

File::~File()
	{
	munmap(m_data, m_size);
	close(m_descriptor);
	}

u32 File::size() const
	{ return m_size; }

const byte* File::data() const
	{ return m_data; }

u32 File::get_u32(u32 offset) const
	{
	assert(offset % sizeof(u32) == 0);
	u32 value = *(const u32*)(m_data + offset);
	return ntohl(value);
	}
