class MyText extends Text
{
    constructor(ctx, text, position, color, size, fontFace, horizontalAlign, verticalAlign)
    {
        super(ctx, text, position, color, size + "vh " + fontFace, horizontalAlign, verticalAlign);
        this.size = size;
        this.fontFace = fontFace;
        this.font = size + "vh " + fontFace;
        
        this.oldTime = Date.now();
    }
    
    update()
    {
        var delta = Date.now() - this.oldTime;
        
        if(this.position.y != 0)
        {
            this.position.y += Math.sign(this.position.y) * delta * 0.001;
        }
        
        this.size += delta * 0.004;
        this.font = this.size + "vh " + this.fontFace;
        
        this.oldTime = Date.now();
    }
}