var canvas;
var ctx;

var sources = [];

function start()
{
	canvas = document.getElementById('canvas');
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
	ctx = canvas.getContext('2d');
	ctx.fillStyle = "RGBA(51, 51, 51, 1)";
	ctx.fillRect(0,0, canvas.width, canvas.height);
    
    usingRecursively([
        "shuttle-core/vector.js",
        "shuttle-core/drawable.js",
        "shuttle-core/settings.js",
        "shuttle-core/world.js",
        "shuttle-core/game.js",
        "shuttle-core/math.js",
        "main.js"
    ], function(){
        draw();
        usingRecursively(sources, function(){
            loading();
            importFontWithCallback("Julius Sans One", "assets/fonts/JuliusSansOne-Regular.ttf", function(){
                importFontWithCallback("Roboto", "assets/fonts/Roboto-Regular.ttf", function(){
                    usingRecursively(sources, ready);
                });
            });
        });
    });
}

function draw()
{
	window.requestAnimationFrame(draw, canvas);
	game._run();
	game.draw();
}

function usingWithCallback(src, callback)
{
	var script = document.createElement("script");
	script.src = src;
	
	script.onload = callback;
	script.onreadystatechange = callback;
	
	var scripts = document.getElementsByTagName("script");
	for(var i = 0; i < scripts.length; i++)
	{
		if(scripts[i].src == scripts[i].baseURI + src)
		{
			return;	
		}
	}
	
	document.head.appendChild(script);
}

function using(src)
{
    sources.push(src);
}

function usingRecursively(srcs, callback)
{
    if(srcs.length > 0)
    {
        usingWithCallback(srcs[0], function(){
            srcs.shift()
            if(srcs.length > 0)
            {
                usingRecursively(srcs, callback);
            }
            else
            {
                callback();
            }
        });
    }
}

function importFontWithCallback(name, src, callback)
{	
	var style = document.createElement("style");
	style.textContent = "@font-face{font-family:'" + name + "';src:url('" + src + "')}";
	document.head.appendChild(style);
	
	document.fonts.load("1em " + name + "").then(callback);
}

window.onresize = function() {
	canvas.width = window.innerWidth;
	canvas.height = window.innerHeight;
    game.world.resize(canvas.width, canvas.height);
};