class World
{
	constructor(game)
	{
		var width = game.canvas.width;
		var height = game.canvas.height;
		
		this.game = game;
		this.position = new Vector(width / 2.0, -height / 2.0);
		this.width = width;
		this.height = height;
        this._scale = 20;
        this.setScale(this._scale);
		this.children = [];
        this.build();
	}
    
    build(){}
	
	update(){}
    
    _update()
    {
        this.update();
        
        this.children.forEach(function(child){
			child._update();
		});
    }
	
	draw()
	{
		ctx.fillStyle = "RGBA(0, 0, 0, " + this.game.settings.motionBlur + ")";
		ctx.fillRect(0,0, this.width, this.height);
		
		this.children.forEach(function(child){
			child.draw();
		});
	}
    
    resize()
    {
		var width = this.game.canvas.width;
		var height = this.game.canvas.height;
		
        this.position = new Vector(width / 2.0, -height / 2.0);
		this.width = width;
		this.height = height;
        
        this.setScale(this._scale);
    }
    
    setScale(height)
    {
        var s = this.height / height;
        this.scale = new Vector(s, s);
    }
	
	add(object)
	{
        this.children.push(object);
        object.parent = this;
	}
    remove(object)
    {
        var i = this.children.indexOf(object);
        this.children.splice(i, 1);
    }
}