/* eslint-disable require-jsdoc */
(function libraryWrapper(window) {
  function defineLibrary() {
    const FilterComponentLib = {};

    const PlugState = {
      PLUG_STATE_OK: 1,
      PLUG_STATE_SELF: 2,
      PLUG_STATE_WRONGTYPE: 3
    };

    FilterComponentLib.PlugState = PlugState;

    class FilterWithPort {
      constructor(fc, p) {
        this.filterComponent = fc;
        this.port = p;
      }
  }

    FilterComponentLib.FilterWithPort = FilterWithPort;

    class FilterComponent {

      constructor(filter, x, y) {
        this.mFilter = filter;
        this.mX = x;
        this.mY = y;
        this.mWidth = 0.1;
        this.mHeight = 0.2;
        this.mP = {};
        this.mP.setTextSize = 30.0;
        this.mP.setColor = 'white';
        this.mP.setTextAlign = 'Paint.Align.CENTER';
        this.mOutputs = [];
        this.mOutputType = this.mFilter.getOutputType();
        this.mInputs = [];
        this.mInputTypes = [];
        this.inputindex = 0;
        for (; this.inputindex < this.mFilter.getInputCount(); this.inputindex++) {
          this.mInputs.push(null);
          const type = FilterLib.ConnectionType.Video;
          this.mInputTypes.push(type);
        }
        if (this.mFilter.getScalarInputCount() > 0) {
          for (; this.inputindex < this.mFilter.getConnectivityOffset(FilterLib.ConnectionType.Scalar)
        + this.mFilter.getScalarInputCount(); this.inputindex++) {
            this.mInputs.push(null);
            const type = FilterLib.ConnectionType.Scalar;
            this.mInputTypes.push(type);
          }
        }

        if (this.mFilter.getTexture3dInputCount() > 0) {
          for (; this.inputindex < this.mFilter.getConnectivityOffset(FilterLib.ConnectionType.Texture3D)
        + this.mFilter.getTexture3dInputCount(); this.inputindex++) {
            this.mInputs.push(null);
            this.mInputTypes.push(FilterLib.ConnectionType.Texture3D);
          }
        }

        if (this.mFilter.getColorListInputCount() > 0) {
          for (; this.inputindex < this.mFilter.getConnectivityOffset(FilterLib.ConnectionType.ColorArray) +
        this.mFilter.getColorListInputCount(); this.inputindex++) {
            this.mInputs.push(null);
            this.mInputTypes.push(FilterLib.ConnectionType.ColorArray);
          }
        }
        if (this.mFilter.getColorInputCount() > 0) {
          for (; this.inputindex < this.mFilter.getConnectivityOffset(FilterLib.ConnectionType.Color) +
        this.mFilter.getColorInputCount(); this.inputindex++) {
            this.mInputs.push(null);
            this.mInputTypes.push(FilterLib.ConnectionType.Color);
          }
        }
        if (this.mFilter.getTexture2dInputCount() > 0) {
          for (; this.inputindex < this.mFilter.getConnectivityOffset(FilterLib.ConnectionType.Texture2D) +
        this.mFilter.getTexture2dInputCount(); this.inputindex++) {
            this.mInputs.push(null);
            this.mInputTypes.push(FilterLib.ConnectionType.Texture2D);
          }
        }
      }


      setView(view) {
        this.mView = view;
      }

      move(x, y) {
        this.mX = x;
        this.mY = y;
      }

      getHeight() {
        return this.mHeight;
      }

      getWidth() {
        return this.mWidth;
      }

      contains(x, y) {
        if (x > this.mX - (this.mWidth / 2.0) &&
      x < this.mX + (this.mWidth / 2.0) &&
      y > this.mY - (this.mHeight / 2.0) &&
      y < this.mY + (this.mHeight / 2.0)) {
          return true;
        }

        return false;
      }

      containsInput(x, y, i) {
        let ratio = 1.0;
        if (this.mView != null) { ratio = this.mView.getWidth() / this.mView.getHeight(); }
        const dx = (x - this.getInputX(i)) * ratio;
        const dy = y - this.getInputY(i);

        if (dx * dx + dy * dy < this.getPlugRadius() * this.getPlugRadius()) {
          return true;
        }
        return false;
      }

      containsOutput(x, y) {
        if (this.mFilter.getOutputCount() < 1) { return false; }
        let ratio = 1.0;
        if (this.mView != null) { ratio = this.mView.getWidth() / this.mView.getHeight(); }
        const dx = (x - this.getOutputX()) * ratio;
        const dy = y - this.getOutputY();

        if ((dx * dx) + (dy * dy) < this.getPlugRadius() * 1.5 * this.getPlugRadius() * 1.5) {
          return true;
        }
        return false;
      }

      getOutputCableWidth() {
        return (this.mOutputType === FilterLib.ConnectionType.Video) ? 6.0 : 2.0;
      }

      getInputCount() {
        const count = this.mFilter.getTotalInputCount();
    // console.log(`input count ${count}`);
        return count;
      }

      getOutputType() {
        return this.mOutputType;
      }

      getInputType(input) {
        return this.mInputTypes[input];
      }

      plugOutput(output, port) {
        if (output === this || ((output.getInputType(port) !== this.getOutputType())
      && !(output.getInputType(port) === FilterLib.ConnectionType.Video &&
      this.getOutputType() === FilterLib.ConnectionType.Texture2D))) return;
        for (let i = 0; i < this.mOutputs.length; i++) {
          if (this.mOutputs[i].filterComponent === output &&
          this.mOutputs[i].port === port) { return; }
        }
        this.mOutputs.push(new FilterWithPort(output, port));
      }

      unplugOutput(output, port) {
        let index = -1;
        for (let i = 0; i < this.mOutputs.length; i++) {
          if (this.mOutputs[i].filterComponent === output &&
            this.mOutputs[i].port === port) { index = i; }
        }
        if (index !== -1) {
          this.mOutputs.splice(index, 1);
            // this.mOutputs.remove(index);
        }
      }

      unplugAll() {
        for (let i = 0; i < this.mInputs.length; i++) {
          if (this.mInputs[i] != null) {
            this.mInputs[i].unplugOutput(this, i);
            this.unplugInput(this.mInputs[i], i);
          }
        }

        for (let i = this.mOutputs.length - 1; i >= 0; i--) {
          this.mOutputs[i].filterComponent.unplugInput(this, this.mOutputs[i].port);
        }
        this.mOutputs = [];
      }

      getFilter() {
        return this.mFilter;
      }

      plugInput(input, i) {
        if (input === this) { return PlugState.PLUG_STATE_SELF; }
        if (input === this.mInputs[i]) { return PlugState.PLUG_STATE_OK; }
        if ((this.getInputType(i) !== input.getOutputType()) &&
          !(this.getInputType(i) === FilterLib.ConnectionType.Video &&
          input.getOutputType() === FilterLib.ConnectionType.Texture2D)) {
          return PlugState.PLUG_STATE_WRONGTYPE;
        }
        if (this.mInputs[i] != null) {
          this.mInputs[i].unplugOutput(this, i);
        }
        this.mInputs[i] = input;
        return PlugState.PLUG_STATE_OK;
      }

      unplugInput(input, i) {
        if (this.mInputs[i] === input) {
          this.mInputs[i] = null;
        }
      }


      getX() {
        return this.mX;
      }

      getY() {
        return this.mY;
      }

      getPlugRadius() {
        return this.mHeight / 6.0;
      }

      getInputX(i) {
        return this.mX - (this.mWidth / 2.0);
      }

      getInputY(i) {
        return this.mY - (this.getPlugRadius() * (this.getInputCount() - 1)) +
          (this.getPlugRadius() * 2.0 * i);
      }

      getOutputX() {
        return this.mX + (this.mWidth / 2.0);
      }

      getOutputY() {
        return this.mY;
      }

      getCableColor(active) {
        if (this.getOutputType() === FilterLib.ConnectionType.Video) {
          if (active) return 'White';
          return 'DarkGray';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Scalar) {
          if (active) return 'red';
          return 'Pink';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Texture3D) {
          if (active) return 'green';
          return 'LightGreen';
        } else if (this.getOutputType() === FilterLib.ConnectionType.ColorArray) {
          if (active) return 'blue';
          return 'lightBlue';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Color) {
          if (active) return 'magenta';
          return 'cyan';
        }
        return 'white';
      }

      getOutputColor(active) {
        if (this.getOutputType() === FilterLib.ConnectionType.Video) {
          if (active) return 'LightGray';
          return 'DarkGray';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Scalar) {
          if (active) return 'red';
          return 'lightRed';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Texture3D) {
          if (active) return 'green';
          return 'LightGreen';
        } else if (this.getOutputType() === FilterLib.ConnectionType.ColorArray) {
          if (active) return 'blue';
          return 'lightBlue';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Color) {
          if (active) return 'magenta';
          return 'cyan';
        }
        return 'white';
      }

      getInputColor(i, active) {
        const inputType = this.getInputType(i);
        if (inputType === FilterLib.ConnectionType.Video) {
          if (active) return 'LightGray';
          return 'DarkGray';
        } else if (inputType === FilterLib.ConnectionType.Scalar) {
          if (active) return 'Red';
          return 'Pink';
        } else if (inputType === FilterLib.ConnectionType.Texture3D) {
          if (active) return 'Green';
          return 'LightGreen';
        } else if (inputType === FilterLib.ConnectionType.ColorArray) {
          if (active) return 'Blue';
          return 'LightBlue';
        } else if (inputType === FilterLib.ConnectionType.Color) {
          if (active) return 'Magenta';
          return 'Cyan';
        }
        return 'White';
      }

      getInput(i) {
        return this.mInputs[i];
      }

      draw(context, c) {
        const ctx = context;
        ctx.lineWidth = 1.0;

        if (this.getOutputType() === FilterLib.ConnectionType.Video) {
          ctx.fillStyle = 'Blue';
          ctx.fillRect(c.width * (this.mX - this.mWidth / 2.0) + 9.0, c.height * (this.mY - this.mHeight / 2.0) + 9.0,
            c.width * (this.mWidth), c.height * (this.mHeight));

          ctx.fillStyle = 'Green';
          ctx.fillRect(c.width * (this.mX - this.mWidth / 2.0) + 6.0, c.height * (this.mY - this.mHeight / 2.0) + 6.0,
            c.width * this.mWidth, c.height * this.mHeight);
        }


        ctx.fillStyle = 'Red';
        if (this.getOutputType() === FilterLib.ConnectionType.Texture3D) {
          ctx.fillStyle = 'Green';
        } else if (this.getOutputType() === FilterLib.ConnectionType.ColorArray) {
          ctx.fillStyle = 'Blue';
        } else if (this.getOutputType() === FilterLib.ConnectionType.Color) {
          ctx.fillStyle = 'Magenta';
        }
        ctx.fillRect(c.width * (this.mX - this.mWidth / 2.0) + 3.0, c.height * (this.mY - this.mHeight / 2.0) + 3.0,
          c.width * this.mWidth, c.height * this.mHeight);

        if (this.getOutputType() === FilterLib.ConnectionType.Scalar) {
          ctx.fillStyle = '#FFC8C8';
            // mP.setColor(Color.rgb(255, 200, 200));
        } else if (this.getOutputType() === FilterLib.ConnectionType.Texture3D) {
          ctx.fillStyle = '#C8FFC8';
            // mP.setColor(Color.rgb(200, 255, 200));
        } else if (this.getOutputType() === FilterLib.ConnectionType.ColorArray) {
          ctx.fillStyle = '#C8C8FF';
            // mP.setColor(Color.rgb(200, 200, 255));
        } else if (this.getOutputType() === FilterLib.ConnectionType.Color) {
          ctx.fillStyle = '#FFC8FF';
            // mP.setColor(Color.rgb(255, 200, 255));
        } else {
          ctx.fillStyle = 'white';
        }


        ctx.fillRect(c.width * (this.mX - this.mWidth / 2.0), c.height * (this.mY - this.mHeight / 2.0),
          c.width * this.mWidth, c.height * this.mHeight);


          // mP.setTypeface(Typeface.create(Typeface.DEFAULT, Typeface.BOLD));
      }
      drawCables(context, c) {
        const ctx = context;
        if (this.mOutputs.length > 1 && false) {
          let middlepointx = 0.0;
          let middlepointy = 0.0;
          for (let i = 0; i < this.mOutputs.length; i++) {
            const fwp = this.mOutputs[i];
            const filter = fwp.filterComponent;
            middlepointx += filter.getInputX(fwp.port);
            middlepointy += filter.getInputY(fwp.port);
          }
          middlepointx /= this.mOutputs.length;
          middlepointy /= this.mOutputs.length;
          middlepointx = (this.getOutputX() * this.mOutputs.length / (this.mOutputs.length + 1)) + middlepointx / (this.mOutputs.length + 1);
          middlepointy = (this.getOutputY() * this.mOutputs.length / (this.mOutputs.length + 1)) + middlepointy / (this.mOutputs.length + 1);


          middlepointx *= c.width;
          middlepointy *= c.height;

          ctx.strokeStyle = this.getCableColor(true);

          ctx.lineWidth = this.getOutputCableWidth();


          let spx = c.width * this.getOutputX();
          let epx = middlepointx;
          let spy = c.height * this.getOutputY();
          let epy = middlepointy;

          this.drawCablePartComplex(spx, spy, epx, epy, c);


          for (let i = 0; i < this.mOutputs.length; i++) {
            const fwp = this.mOutputs[i];
            const filter = fwp.filterComponent;

            ctx.strokeStyle = this.getCableColor(true);

            ctx.lineWidth = this.getOutputCableWidth();


            spx = middlepointx;
            epx = c.width * filter.getInputX(fwp.port);
            spy = middlepointy;
            epy = c.height * filter.getInputY(fwp.port);

            this.drawCablePartComplex(spx, spy, epx, epy, ctx, c);
          }
        } else {
          for (let i = 0; i < this.mOutputs.length; i++) {
            const fwp = this.mOutputs[i];
            const filter = fwp.filterComponent;

            ctx.strokeStyle = this.getCableColor(true);

            ctx.lineWidth = this.getOutputCableWidth();


            const spx = c.width * this.getOutputX();
            const epx = c.width * filter.getInputX(fwp.port);
            const spy = c.height * this.getOutputY();
            const epy = c.height * filter.getInputY(fwp.port);

            this.drawCablePartComplex(spx, spy, epx, epy, ctx, c);
          }
        }
      }

      drawCablePartComplex(spx, spy, epx, epy, ctx, c) {
        let t = 1.0;
        t += Math.max(0.0, spx - epx) * 20.0 / this.mWidth;

        const cp1x = spx + (t * this.mWidth) * c.width;
        const cp2x = epx - c.width * (t * this.mWidth);
        const cp1y = spy;
        const cp2y = epy;

        const dx = spx - epx;
        const dy = spy - epy;
        const dx2 = cp1x - cp2x;
        const dy2 = cp1y - cp2y;

        const ratio = Math.min((Math.sqrt(dx * dx + dy * dy) / Math.sqrt(dx2 * dx2 + dy2 * dy2)), 1.0);

          // if(Math.sqrt(dx*dx+dy*dy)<2.0* Math.sqrt(dx2*dx2-dy2*dy2)){
        const cp1xf = (spx * (1.0 - ratio) + cp1x * ratio);
        const cp2xf = (epx * (1.0 - ratio) + cp2x * ratio);
        const cp1yf = (spy * (1.0 - ratio) + cp1y * ratio);
        const cp2yf = (epy * (1.0 - ratio) + cp2y * ratio);

        this.drawCablePart(spx, spy, cp1xf, cp1yf, cp2xf, cp2yf, epx, epy, ctx, c);

        if (this.getOutputType() === FilterLib.ConnectionType.Video) {
          ctx.strokeStyle = 'black';
          ctx.lineWidth = 3.0;
          this.drawCablePart(spx, spy, cp1xf, cp1yf, cp2xf, cp2yf, epx, epy, ctx, c);
        }
      }

      drawCablePart(spx, spy, cp1xf, cp1yf, cp2xf, cp2yf, epx, epy, context, c) {
        const ctx = context;
        const pieces = 40;
        const px = spx;
        const py = spy;
        ctx.lineCap = 'round';
        ctx.beginPath();
        ctx.moveTo(px, py);
        for (let i = 1; i <= pieces; i++) {
          const cx = FilterComponent.bi(
              spx,
              cp1xf,

              cp2xf,
              epx,
              i / pieces);
          const cy = FilterComponent.bi(
                spy,
                cp1yf,

                cp2yf,
                epy,
                i / pieces);
          ctx.lineTo(cx, cy);
        }
        ctx.stroke();
      }

      drawConnections(context, c) {
        const ctx = context;
        if (this.getInputCount() > 0) {
          for (let i = 0; i < this.getInputCount(); i++) {
            const index = i;
            ctx.beginPath();
            ctx.arc(c.width * this.getInputX(index), c.height * this.getInputY(index),
          (c.height * this.getPlugRadius()) / 1.5, 0, 2 * Math.PI);
            ctx.fillStyle = this.getInputColor(index, this.getInput(index) !== null);
            ctx.fill();
          }
        }

        if (this.mFilter.getOutputCount() > 0) {
          ctx.beginPath();
          ctx.arc(c.width * this.getOutputX(), c.height * this.getOutputY(),
        (c.height * this.getPlugRadius()) / 1.5, 0, 2 * Math.PI);
          ctx.fillStyle = this.getOutputColor(this.mOutputs.length > 0);
          ctx.fill();
        }
      }

      drawTexts(context, c) {
        const ctx = context;
        ctx.fillStyle = 'black';
        ctx.font = '16px Arial';
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        ctx.fillText(this.mFilter.getName(), c.width * this.mX, c.height * this.mY);
      }


      getOutput(i) {
        if (i >= 0 && i < this.getOutputCount() &&
      this.mOutputs != null && this.mOutputs.length > 0) {
          return this.mOutputs[i].filterComponent;
        }
        return null;
      }

      getOutputCount() {
        if (this.mOutputs != null) {
          return this.mOutputs.length;
        }
        return 0;
      }

      getIndex() {
        return this.index;
      }

      setIndex(i) {
        this.index = i;
      }


      static ci(a, b, c, d, x) {
        const P = (d - c) - (a - b);
        const Q = (a - b) - P;
        const R = c - a;
        const S = b;
        return (P * x * x * x) + (Q * x * x) + (R * x) + S;
      }

      static bi(a, b, c, d, x) {
        return a * (-x * x * x + 3.0 * x * x - 3.0 * x + 1.0) +
          b * (3.0 * x * x * x - 6.0 * x * x + 3.0 * x) +
          c * (-3.0 * x * x * x + 3.0 * x * x) + d * (x * x * x);
      }
}

    FilterComponentLib.FilterComponent = FilterComponent;

    return FilterComponentLib;
  }
  if (typeof (FilterComponentLib) === 'undefined') window.FilterComponentLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
