/* eslint-disable require-jsdoc*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const MedianCutLib = {};
    const ColorRGB = {
      RED: 0,
      GREEN: 1,
      BLUE: 2
    };

    function findGreatestRange(bucket, start, end) {
      // console.log('findgreatest range');
      let rmax = 0;
      let rmin = 255;
      let gmax = 0;
      let gmin = 255;
      let bmax = 0;
      let bmin = 255;
      for (let i = start; i < end; i++) {
        const c = bucket[i];
        const r = (c & 0x00ff0000) >> 16;
        const g = (c & 0x0000ff00) >> 8;
        const b = c & 0x000000ff;
        if (r > rmax) {
          rmax = r;
        }
        if (g > gmax) {
          gmax = g;
        }
        if (b > bmax) {
          bmax = b;
        }
        if (r < rmin) {
          rmin = r;
        }
        if (g < gmin) {
          gmin = g;
        }
        if (b < bmin) {
          bmin = b;
        }
      }

      const rrange = rmax - rmin;
      const grange = gmax - gmin;
      const brange = bmax - bmin;
      // console.log(`ranges ${rrange} ${grange} ${brange}`);
      if (grange >= rrange && grange >= brange) {
        // console.log('green');
        return ColorRGB.GREEN;
      } else if (rrange >= brange) {
        // console.log('red');
        return ColorRGB.RED;
      }
      // console.log('blue');
      return ColorRGB.BLUE;
    }


    MedianCutLib.getColors = function getColors(bucketsx, pixelCount, maxColors) {
      console.log(`getColors${pixelCount}`);
      const finalColors = new Uint8Array(4 * maxColors);
      let buckets = new Uint32Array(pixelCount);
      /*
      for (let i = 0; i < maxColors; i++) {
        const offset = i * 4;
        finalColors[offset] = Math.floor(Math.random() * 255.0);
        finalColors[offset + 1] = Math.floor(Math.random() * 255.0);
        finalColors[offset + 2] = Math.floor(Math.random() * 255.0);
        finalColors[offset + 3] = 255;
      }
      */
      let bucketcount = 1;

      for (let i = 0; i < pixelCount; i++) {
        const offset = 4 * i;
        buckets[i] = ((bucketsx[offset + 1] << 8) & 0xff00ff00) | ((bucketsx[offset + 2]) & 0x000000ff) | ((bucketsx[offset + 0] << 16) & 0x00ff0000);
        // buckets[i] = 0xff000000 | ((bucketsx[offset + 0] << 16) & 0x00ff0000) | ((bucketsx[offset + 1] << 8) & 0x0000ff00) | ((bucketsx[offset + 2] & 0x000000ff));
      }

      let offsets = [];
      // const subSort = (arr, i, n, sortFx) => [].concat(...arr.slice(0, i), ...arr.slice(i, i + n).sort(sortFx), ...arr.slice(i + n, arr.length));
      const subSort = function subsort(arr, i1, i2, sortfx) {
        const havebucket = new Uint32Array(arr.length);
        // const shittyarray = [];
        // shittyarray.concat
        havebucket.set(arr.slice(0, i1), 0);
        havebucket.set(arr.slice(i1, i2).sort(sortfx), i1);
        havebucket.set(arr.slice(i2, arr.length), i2);
        return havebucket;
      };
      offsets.push(0);
      offsets.push(pixelCount);
      while (bucketcount < maxColors) {
        const oldoffsets = offsets;
        offsets = [];
        for (let i = 0; i < bucketcount; i++) {
          offsets.push(oldoffsets[i * 2]);
          const count = Math.floor((oldoffsets[(i * 2) + 1] - oldoffsets[i * 2]) / 2);
          offsets.push(oldoffsets[i * 2] + count);
          offsets.push(oldoffsets[i * 2] + count);
          offsets.push(oldoffsets[(i * 2) + 1]);
          const sortColor = findGreatestRange(buckets, oldoffsets[i * 2], oldoffsets[(i * 2) + 1]);
          const start = oldoffsets[2 * i];
          const end = oldoffsets[(2 * i) + 1];
          if (sortColor === ColorRGB.RED) {
            buckets = subSort(buckets, start, end,
                      (a, b) => ((a & 0x00ff0000) - (b & 0x00ff0000))
                    );
          } else if (sortColor === ColorRGB.GREEN) {
            buckets = subSort(buckets, start, end,
                      (a, b) => ((a & 0x0000ff00) - (b & 0x0000ff00))
                    );
          } else {
            buckets = subSort(buckets, start, end,
                      (a, b) => ((a & 0x000000ff) - (b & 0x000000ff))
                    );
          }
        }
        bucketcount *= 2;
      }


      for (let i = 0; i < maxColors; i++) {
        let r = 0;
        let g = 0;
        let b = 0;

        for (let j = offsets[i * 2]; j < offsets[(i * 2) + 1]; j++) {
          r += (buckets[j] & 0x00ff0000) >> 16;
          g += (buckets[j] & 0x0000ff00) >> 8;
          b += buckets[j] & 0x000000ff;
        }

        let count = offsets[(i * 2) + 1] - offsets[i * 2];
        if (count === 0) {
          count = 1;
        }

        r /= count;
        g /= count;
        b /= count;

/*
        const index = Math.floor((offsets[i * 2] + offsets[(i * 2) + 1]) / 2);
        r = (buckets[index] & 0x00ff0000) >> 16;
        g = (buckets[index] & 0x0000ff00) >> 8;
        b = buckets[index] & 0x000000ff;
        */
        const offset = i * 4;
        finalColors[offset] = Math.floor(r);
        finalColors[offset + 1] = Math.floor(g);
        finalColors[offset + 2] = Math.floor(b);
        finalColors[offset + 3] = 255;
      }
      console.log('end getColors');
      return finalColors;
    };


    return MedianCutLib;
  }
  if (typeof (MedianCutLib) === 'undefined') window.MedianCutLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
