/* eslint-disable require-jsdoc*/
/* eslint-disable no-undef*/
(function libraryWrapper(window) {
  function defineLibrary() {
    const ScalarFiltersLib = {};
    const ConnectionType = FilterLib.ConnectionType;
    // Scalar filters

    ScalarFiltersLib.MaxScalarFilter = class MaxScalarFilter extends FilterLib.Filter {
      constructor() {
        super('MaxScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = Math.max(this.mScalars[0], this.mScalars[1]);
      }
    };

    ScalarFiltersLib.MinScalarFilter = class MinScalarFilter extends FilterLib.Filter {
      constructor() {
        super('MinScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = Math.min(this.mScalars[0], this.mScalars[1]);
      }
    };

    ScalarFiltersLib.NumberFilter = class NumberFilter extends FilterLib.Filter {
      constructor() {
        super('Number', 0, 1, ConnectionType.Scalar, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = this.mScalars[0];
      }
    };

    ScalarFiltersLib.AddScalarFilter = class AddScalarFilter extends FilterLib.Filter {
      constructor() {
        super('AddScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = this.mScalars[0] + this.mScalars[1];
      }
    };

    ScalarFiltersLib.SubtractScalarFilter = class SubtractScalarFilter extends FilterLib.Filter {
      constructor() {
        super('SubtractScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = this.mScalars[0] - this.mScalars[1];
      }
    };

    ScalarFiltersLib.MultiplyScalarFilter = class MultiplyScalarFilter extends FilterLib.Filter {
      constructor() {
        super('MultiplyScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = this.mScalars[0] * this.mScalars[1];
      }
    };

    ScalarFiltersLib.DivideScalarFilter = class DivideScalarFilter extends FilterLib.Filter {
      constructor() {
        super('DivideScalar', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = this.mScalars[0] / this.mScalars[1];
      }
    };

    ScalarFiltersLib.MinusScalarFilter = class MinusScalarFilter extends FilterLib.Filter {
      constructor() {
        super('MinusScalar', 0, 1, ConnectionType.Scalar, 1);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
      }
      calculate() {
        this.mScalarOutput = -this.mScalars[0];
      }
    };

    ScalarFiltersLib.SineFilter = class SineFilter extends FilterLib.Filter {
      constructor() {
        super('Sine', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
        this.mIsTimeFilter = true;
      }
      setTime(time) {
        this.mScalars[1] = time;
      }
      calculate() {
        const scaledTime = this.mScalars[1] / this.mScalars[0] * 2.0;
        this.mScalarOutput = Math.sin(scaledTime * Math.PI * 2.0) * 0.5 + 0.5;
      }
    };

    ScalarFiltersLib.SquareFilter = class SquareFilter extends FilterLib.Filter {
      constructor() {
        super('Square', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
        this.mIsTimeFilter = true;
      }
      setTime(time) {
        this.mScalars[1] = time;
      }
      calculate() {
        const scaledTime = this.mScalars[1] / this.mScalars[0];
        this.mScalarOutput = ((scaledTime - Math.floor(scaledTime)) > 0.5) ? 1.0 : 0.0;
      }
    };

    ScalarFiltersLib.SawFilter = class SawFilter extends FilterLib.Filter {
      constructor() {
        super('Saw', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
        this.mIsTimeFilter = true;
      }
      setTime(time) {
        this.mScalars[1] = time;
      }
      calculate() {
        const scaledTime = this.mScalars[1] / (this.mScalars[0] * 2.0);
        this.mScalarOutput = scaledTime - Math.floor(scaledTime);
      }
    };

    ScalarFiltersLib.TriangleWaveFilter = class TriangleWaveFilter extends FilterLib.Filter {
      constructor() {
        super('TriangleWave', 0, 1, ConnectionType.Scalar, 2);
        this.mFragSourceFile = undefined;
        this.mVertSourceFile = undefined;
        this.mIsCalculateFilter = true;
        this.mIsTimeFilter = true;
      }
      setTime(time) {
        this.mScalars[1] = time;
      }
      calculate() {
        const scaledTime = this.mScalars[1] / (this.mScalars[0] * 2.0);
        this.mScalarOutput = 2.0 * Math.abs(scaledTime - Math.floor(scaledTime + 0.5));
      }
    };
    return ScalarFiltersLib;
  }
  if (typeof (ScalarFiltersLib) === 'undefined') window.ScalarFiltersLib = defineLibrary(); // eslint-disable-line no-param-reassign, no-undef
  else console.log('Library already defined.'); // eslint-disable-line no-console
}(window)); // eslint-disable-line no-undef
