; The Grid - Windows 512 bytes intro by TomCat/Abaddon

RESX EQU 1280/5
RESY EQU 768

BASE EQU 00400000H
ORG BASE
USE32

FORMAT BINARY AS 'exe'
DIV24:           DW 'MZ'       ; 00.e_magic
                 DW 0x3D2A     ; 02.e_cblp
                 DD 'PE'       ; 04.Signature
                 DW 014CH      ; 08.Machine
                 DW 0          ; 0A.NumberOfSections
LoadLibraryA:    DD 0xE9826FC6 ; 0C.TimeDateStamp
GetWindowRect:   DD 0xF9AC1F38 ; 10.PointerToSymbolTable
ShowCursor:      DD 0x19A434A8 ; 14.NumberOfSymbols
                 DW 8          ; 18.SizeOfOptionalHeader
                 DW 2          ; 1A.Characteristics IMAGE_FILE_EXECUTABLE_IMAGE
ZOOMY:           DW 010BH      ; 1C.Magic
                 DW 0x49A0     ; 1E.Major+MinorLinkerVersion
GetDC:           DD 0xA4D450D1 ; 20.SizeOfCode
CreateWindowExA: DD 0xF8820ECC ; 24.SizeOfInitializedData
StretchDIBits:   DD 0x4ED54D5C ; 28.SizeOfUninitializedData
                 DD start-BASE ; 2C.AddressOfEntryPoint
ExitProcess:     DD 0x38A66AE8 ; 30.BaseOfCode
edit:            DD 'edit'     ; 34.BaseOfData
                 DD BASE       ; 38.ImageBase
                 DD 4          ; 3C.SectionAlignment (.e_lfanew)
                 DD 4          ; 40.FileAlignment
GetAsyncKeyState:DD 0xDE59F860 ; 44.Major+MinorOperatingSystemVersion
GetTickCount:    DD 0xFBBA3133 ; 48.Major+MinorImageVersion
DIV1024:         DW 4          ; 4C.MajorSubsystemVersion
                 DB 80H        ; 4E.MinorSubsystemVersion
RADIUS2:         DW 7F3AH      ; 50.Win32VersionValue
color2:          DB 230,26,255
color1:          DB 230        ; 54.SizeOfImage (malloc)
DIV128:          DB 177,77,0
                 DB 3CH        ; 58.SizeOfHeaders
HALF:            DD 3F000000H  ; 5C.CheckSum
color3:          DB 26,140,255
                 DW 2          ; 60.Subsystem 2->gui
                 DW 0          ; 62.DllCharacteristics
start:                         ; 64.SizeOfStackReserve
 MOV ECX,30H
 MOV EAX,[FS:ECX]              ; access to PEB
 PUSH EDX
 MOV EAX,[EAX+0x0C]
 POP ESI
 MOV EAX,[EAX+0x1C]
 JMP base
SHINE:           DW 440        ; 76.
                 DD 0          ; 78.NumberOfRvaAndSizes;

libname:         DB 'gdi32',0,'user32',0

base:
 MOV EBP,[EAX+0x20]
 MOV EBX,[EAX+0x08]
 CMP [EBP+0x18],CH
 MOV EAX,[EAX]
 JNZ base

 LEA EDI,[EDX-start+libname]
scan:
 MOV CL,48H/4
func:
 PUSHAD
 LEA ESI,[ESI-start+BASE+ECX*4]
 MOV EAX,[EBX+0x3C]            ; EAX = RVA NT Header
 MOV EBP,[EBX+EAX+0x78]        ; EBP = RVA Data Directory
 ADD EBP,EBX                   ; EBP = RVA -> VA

hash:
; EBX = imagebase of dll
; EAX = imagebase + &NT_Hdr
; EBP = imagebase + &DataDirectory
; EDI = &libname
; ESI = &hashed function name

 MOV ECX,[EBP+0x18]            ; ECX = Num Exports
redo:
 JECXZ done                    ; ECX = 0 No More Exports
 DEC ECX                       ; ECX = Num Exports Decreased
 MOV EAX,[EBP+0x20]            ; EAX = RVA Exports Asciiz
 CDQ                           ; EDX = 0 (.PointerToLinenumbers)
 ADD EAX,EBX                   ; EAX = RVA -> VA
 MOV EDI,[EAX+ECX*4]           ; EDI = RVA Export Asciiz Index
 ADD EDI,EBX                   ; EDI = RVA -> VA
 SALC                          ; AL = 0
calc:
 ROL EDX,6                     ; EDX = Hash Preparation
 XOR DL,[EDI]                  ; EDX = Add Char Export Asciiz
 SCASB                         ; AL  = 0 Only For End of Asciiz
 JNZ calc                      ; If Not Zero Keep Hashing
 CMP EDX,[ESI]                 ; Check Hash Against Input
 JNZ redo                      ; If Not Equal Hash Next Function

 MOV EDX,[EBP+0x24]            ; EDX = RVA Function Ordinal
 ADD EDX,EBX                   ; EDX = RVA -> VA
 MOVZX ECX,WORD [EDX+ECX*2]
 MOV EDX,[EBP+0x1C]            ; EDX = Function RVAS List
 ADD EDX,EBX                   ; EDX = RVA -> VA
 ADD EBX,[EDX+ECX*4]           ; EBX = Function RVA
 MOV [ESI],EBX
done:
 POPAD                         ; Restore Registers
 LOOP func

 PUSH EDI
 CALL DWORD [ESI-start+LoadLibraryA]
 XCHG EBX,EAX

 PUSH 6
 POP ECX
@@:
 PUSH EBX
 INC EDI                       ; next dll name
 LOOP @B

 TEST EBX,EBX
 JNZ scan

; EBX = 0
; ESI = start

 MUL EBX       ; EAX = 0, EDX = 0
 MOV AH,RESX/256;EAX = RESX
 MOV DH,RESY/256;EDX = RESY

 PUSH 00200001H; .biPlanes+.biBitCount
 PUSH EDX      ; .biHeight (negative value->vertical flip)
 PUSH EAX      ; .biWidth
 PUSH 40       ; .biSize
 MOV EBP,ESP   ; BITMAPINFOHEADER

 PUSH 00CC0020H; SRCCOPY
 PUSH EBX      ; DIB_RGB_COLORS
 PUSH EBP      ; BITMAPINFOHEADER
 PUSH start+RESX*RESY
 PUSH EDX      ; RESY
 PUSH EAX      ; RESX

 MOV CL,15     ; StretchDIBits:2+ShowCursor:1+CreateWindowEx:8+RECT:4
@@:
 PUSH EBX      ; fill the stack by zeros
 LOOP @B

;ShowCursor(FALSE);
 CALL DWORD [ESI-start+ShowCursor]

 LEA EAX,[ESI-start+edit]
 PUSH 91000000H; WS_POPUP|WS_MAXIMIZE|WS_VISIBLE
 PUSH EBX
 PUSH EAX
 PUSH EBX

;CreateWindowEx(0,"edit",0,WS_POPUP|WS_MAXIMIZE|WS_VISIBLE,0,0,0,0,0,0,0,0);
 CALL DWORD [ESI-start+CreateWindowExA]

 MOV EDX,ESP
 PUSH EAX      ; hwnd
 PUSH EDX      ; RECT
 PUSH EAX      ; hwnd
 CALL DWORD [ESI-start+GetWindowRect]

;GetDC(hwnd);
 CALL DWORD [ESI-start+GetDC]
 PUSH EAX      ; hdc

main:
 CALL DWORD [ESI-start+GetTickCount]
 XCHG EBP,EAX  ; EBP = time counter in ms after reboot
 MOV ECX,RESX*RESY
 LEA EDI,[ESI+ECX]
nextpixel:
 PUSHAD
 MOV [EDI],EBX ; clear pixel

 LEA EDX,[ECX+(-1*(129+376*256))] ; center: -1*(RESX/2+RESY/2*256)
 MOV AL,5
 IMUL DL
 MOV [ESI],EDX ; y
 FILD WORD [ESI+1]
 FLD ST0       ; i y
 FMUL DWORD [ESI-start+DIV24]
 FMUL ST0,ST0  ; i = (2y/RESY)2*256 = (32y/RESY)2 = (y/24)2
 ADD AX,-128
 MOV [ESI],EAX ; x
 FILD WORD [ESI]

 LEA ECX,[ESI-start+color3]
 CALL sphere

 MOV CL,color1-BASE
 MOV [ESI],EBP ; t
 TEST EDX,EDX
 CDQ
 JS sky        ; upper half of the screen

 MOV CL,color2-BASE
 FADD ST0,ST0  ; 2x i y
 FDIV ST0,ST2  ; 2x/y i y

 FLD DWORD [ESI-start+ZOOMY]
 FDIV ST0,ST3  ; ZOOMY/y+t 2x/y i y 
 FIADD DWORD [ESI]
 FMUL DWORD [ESI-start+DIV1024]

.1:
 FIST DWORD [ESI]
 FISUB DWORD [ESI]
 FADD ST0,ST0
 FMUL ST0,ST0
 FMUL ST0,ST0
 FXCH
 CMC
 JC .1
 FADDP         ; g i y
 FMUL ST1,ST0  ; g i*g y 

sky:           ; x i y
 FSTP ST0      ; i y
 CALL putpixel
 POPAD
 SCASD
 LOOP nextpixel

;StretchDIBits(hdc,rc.left,rc.top,rc.right,rc.bottom,0,0,ResX,ResY,pixels,bmpnfo,0,SRCCOPY);
 CALL DWORD [ESI-start+StretchDIBits]
 SUB ESP,13*4  ; repair the stack frame (preserves StretchDIBits arguments)

 PUSH 1BH      ; VK_ESCAPE
 CALL DWORD [ESI-start+GetAsyncKeyState]
 TEST EAX,EAX
 JZ main

 JMP DWORD [ESI-start+ExitProcess]

sphere:
 FLD ST2       ; y x i y
 FMUL ST0,ST0  ; y2 x i y
 FLD ST1       ; x y2 x i y
 FMUL ST0,ST0  ; x2 y2 x i y
 FADDP         ; x2+y2 x i y
 FILD WORD [ESI-start+RADIUS2] 
 FCOMI ST0,ST1 ; r2 x2+y2 x i y
 JNA skip      ; r2 x2+y2 x i y

 FSUBRP        ; r2-x2-y2 x i y
 FSQRT         ; z x i y
 FLD ST1       ; x z x i y
 FMUL ST0,ST1  ; z*x z x i y
 FMUL DWORD [ESI-start+DIV128]
 FXCH ST2      ; x z z*x/128 i y
 FADD ST0,ST4  ; x+y z z*x/128 i y
 FSUBR ST0,ST1 ; z-x-y z z*x/128 i y
 FADD ST1,ST0  ; z-x-y 2z-x-y z*x/128 i y
 NEG EBP
 MOV DL,25     ; ambient

putpixel:
 FISTP DWORD [ESI]
 FILD WORD [ESI-start+SHINE]
.1:
 MOV EAX,[ESI]
 SHR EAX,1
 NOT AH
 AND AL,AH
 ADD AL,DL
 MUL BYTE [ECX+EBX]
 ADD AX,AX
 JC .2
 ADD AH,[EDI+EBX]
 JC .2
 FCOMI ST0,ST1
.2:
 SALC
 OR AL,AH
 MOV [EDI+EBX],AL
 INC EBX
 JPO .1
 SUB EBX,EBX

skip:
 FCOMPP        ; x i s
RETN
