var Points = function(){
    PartBase.call(this);

    //POSTPROCESSING
    //this.setHorizontalBlur(10);
    //this.setVerticalBlur(10);
    this.setEdgeDetection();
    this.setDoF({
        focus : 1.0,
        maxblur: 8.0,
        aperture: 0.02
    });
    this.setBloom(4);
    //this.setBloom(6);

    var material = new THREE.PointsMaterial({ color: 0xDD475A});
    var geometry = new THREE.Geometry();
    geometry.dynamic = true;
    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(6, 60, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    for(var k = 0; k < this.lsystem.points.length; ++k){
        var point = this.lsystem.points[k];
        geometry.vertices.push(new THREE.Vector3(point.x/2, point.y, -point.z/2));
        geometry.vertices.push(new THREE.Vector3(-point.x, -point.y/2, point.z));

        geometry.vertices.push(new THREE.Vector3(-point.x/2, point.y/2, point.z/2));
        geometry.vertices.push(new THREE.Vector3(point.x, -point.y, -point.z));

        geometry.vertices.push(new THREE.Vector3(point.x/3, point.y/6, point.z));
        geometry.vertices.push(new THREE.Vector3(-point.x/3, -point.y/6, point.z/2));
        

        geometry.vertices.push(new THREE.Vector3(-point.x/6, point.y/5, point.z));
        geometry.vertices.push(new THREE.Vector3(point.x/6, -point.y/5, point.z));
        
    }
    geometry.verticesNeedUpdate = true;
    this.points = new THREE.Points(geometry, material);

    this.scene.add(this.points);
    this.createSurroundings();
    this.showText = false;

};

Points.prototype = PartBase.prototype.inheritance();

Points.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var lp = TDEMO.SYNC.getObjRotation();
    this.points.rotation.x = lp.x;
    this.points.rotation.y = lp.y;
    this.points.rotation.z = lp.z;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.points.position.x = p.x;
    this.points.position.y = p.y;
    this.points.position.z = p.z;

    var text = document.getElementById("credits");
    var hb = TDEMO.SYNC.getHeartBeat();
    if(hb > 0){
        if(this.showText === false){
            text.style.display = "block";
            this.showText = true;
        }
        text.style.opacity = hb;
    }
    else if( hb <= 0 && this.showText === true){
        text.style.display = "none";
        this.showText = false;
  }
};

Points.prototype.createSurroundings = function(){

    this.scene.fog = new THREE.Fog(0x200504, 100, 600);
    var material = new THREE.MeshStandardMaterial({
        color : 0x000000,
        side : THREE.BackSide
    });
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(1000, 64, 64), material);
    this.scene.add(this.skySphere);
}
