;---"concrete sprout" by Kuemmel for Function 2020
;---"...inspired by IQ's formulas and 90's bump mapping
max_bump_height=6 ;glitches above 6
leaves=5

org 100h
use16

;---"init stuff"
sub al,-(0x13+0x80) ;no screen clear needed and provides valid back buffer   
mov fs,word[si]     ;results in 0x6d2c
int 10h
push 0a000h-20	    ;'cures' first line bump map glitch for free
pop es
mov ah,0x80
mov gs,ax
fninit
fld1   ;1
fldz   ;t=0   1

palette_loop:
    mov dx,3c8h
    mov al,cl
    out dx,al
    inc dx
    shr al,2
    out dx,al
    out dx,al
    out dx,al
loop palette_loop

;---"main intro loop"
main_loop:

;---"create clover type texture from IQ's formulations"
mov cx,-101
   y_loop:		 
   mov ax,-160		     ;st0		    st1 st2 st3 st4 st5 st6 st7
   x_loop:			     ;t 		  1
      mov word[bp+si],cx
      fild word[bp+si]	 ;y			      t   1
      mov word[bp+si],ax
      fild word[bp+si]	 ;x			     ys   t   1
      fld st1		     ;ys		     xs  ys   t   1
      fmul st0,st0	     ;ys*ys		     xs  ys   t   1
      fld st1		     ;xs	      ys*ys  xs  ys	  t   1
      fmul st0,st0	     ;xs*xs	      ys*ys  xs  ys   t   1
      faddp st1,st0	     ;xs*xs+ys*ys    xs  ys   t   1
      fmul dword[si]	 ;...*f 	     xs  ys   t   1
      fsqrt			     ;r 		 xs  ys   t   1
      fxch st2		     ;ys		     xs   r   t   1
      fpatan		     ;atn(ys/xs)	  r   t   1
      fimul word[si+4]	 ;a=atn*le		  r   t   1
      fadd st0,st2	     ;a+t		      r   t   1
      fld st0		     ;a+t		    a+t   r   t   1
      cmp bh,max_bump_height
      jbe skip_wiggle
	     fadd st0,st3	 ;a+t+t 	    a+t   r   t   1
      skip_wiggle:
      fcos			     ;g=cos(a+2*t)	a+t   r   t   1
      fmul st0,st0	     ;g=g*g		a+t   r   t	  1
      fmul st0,st0	     ;g=g*g*g*g a+t   r   t   1
      fxch st1		     ;a+t		      g   r   t   1
      fsin			     ;s=sin(a+t)	  g   r   t	  1
      fadd st0,st4	     ;d=1+s	      g   r   t   1
      fadd st0,st4	     ;d=2+s	      g   r   t   1
      faddp st1,st0	     ;d=2+s+g	      r   t   1
      fdivp st1,st0	     ;c=r/d		  t   1 	
      fcomi st0,st2	     ;c>1 ?		      t   1
      fcmovnb st0,st2	 ;c>1 => c=1	  t   1
      fimul word[si]	 ;c*255 	      t   1
      fistp word[bp+si]  ;t			      1
      mov dl,byte[bp+si] ;dl for not fucking up ax/cx/bx
      mov byte[fs:di],dl
      inc ax
      inc di
      cmp ax,160	     ;using ax here saves 1 Byte
   jne x_loop
   inc cx
   cmp cx,101  ;=> calc 202 lines => first line of screen is okay then...
jne y_loop

;---"calculate bump map and plot"
xor di,di		   ;needed here
push bx 		   ;backup global frame counter
xy_bump_loop:
   mov bx,320	   ;re-used later as an offset
   xor dx,dx
   mov ax,di
   div bx
   xchg ax,cx  ;cx=y | dx=x 
   bump_loop:
      movzx ax,byte[fs:di+bx]  ;v1=p(y+320)|p(x+1)
      neg bx			       ;-1 => 1 |-320 => 320) 
      movzx bp,byte[fs:di+bx]  ;v2=p(y-320)|p(x-1)
      sub ax,bp 		       ;(v1-v2)
      bump_height:		   ;self-modifying code address
      imul ax,ax,word 0x00     ;(v1-v2)*h (bump height factor)...0 for init, imul ax,ax,word 0x0000
      sar ax,5
      add ax,cx 		       ;ux|uy = x+(v1-v2)*h|y+(v1-v2)*h
      sar ax,2			       ;2;limit ux|uy for mul
      imul ax,ax		       ;ux*ux|uy*uy in range 0...32767
      inc bx			   ;is bx = -1 or -320 ? => becomes 0 if -1 => loop or not
      xchg ax,si		       ;backup result		    ;no flag change
      xchg cx,dx		       ;switch x and y for add	;no flag change
      mov bx,1			   ;switch to y offset	    ;no flag change
   jnz bump_loop	       ;loop twice
   add ax,si			   ;ux*ux+uy*uy     
   mov si,constants	       ;good enough to do it here, who cares for first frame ;-)
   mov bp,si		       ;just to point somewhere above code for all [bp+si] actions
   mov word[bp+si],ax
   fild word[bp+si]
   fsqrt			       ;sqrt(ux*ux+uy*uy)...just looks better than a shift...
   fistp word[bp+si]
   mov ax,word[bp+si]
   shl ax,1
   cmp ax,word[si]		   ;catch overflow
   cmova ax,word[si]	   ;clamp to 255
   mov byte[gs:di],al	   ;plot to back buffer
   inc di
jnz xy_bump_loop
pop bx				   ;restore global frame counter

;---"inc global timer for fade inn / rotation wiggle trigger"
inc bx
inc bx

;---"vsync for timing & flicker reduce"
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---"plot buffer to screen"
plot_buffer:	       ;di zero here
   mov ax,word[gs:di]  ;words for speedup
   stosw
   test di,di
jnz plot_buffer

;---"flow control - add timer offset for rotation"
fadd dword[si+3]	   ;t+offset	1

;---"flow control - fade in/bump height"
cmp bh,max_bump_height
ja bump_height_mod_done
   mov ax,bx
   shr ax,3
   mov word[si-(constants-(bump_height+2))],ax ;modifiy constant in imul ax,ax,0
bump_height_mod_done:

;---"check keyboard" 
check_keyboard:
in al,0x60
dec al			  ;ah not zero due to copy loop...if plot speed is okay change byte above and use ax
jnz main_loop
ret

constants:
dw    255  ;int   +0 'float to int factor' and other helper
dw 0x3a90  ;float +0 'size' 0.0006 0x3a20 max) <-> 0.0016 (0x3ad2 min)
dw leaves  ;int   +4 'amount of leaves'
db   0x3d  ;float +3 'timer ca. 0.03