"use strict";

class MusicManager {
    _camera;
    _music;

    constructor(camera) {
        this._camera = camera; 
    }

    load(path) {
        // create an AudioListener and add it to the camera
        var listener = new THREE.AudioListener();
        this._camera.add(listener);

        // create a global audio source
        var music = new THREE.Audio(listener);
        this._music = music;

        // load a sound and set it as the Audio object's buffer
        var audioLoader = new THREE.AudioLoader();
        return new Promise((resolve) =>
            audioLoader.load(path, function (buffer) {
                music.setBuffer(buffer);
                music.setLoop(false);
                music.setVolume(0.5);
                resolve();
            })
        );
    }

    play(offset) {
        if (offset)
            this._music.offset = offset / 1000;
        this._music.play();
    }

    pause() {
        this._music.pause();
    }
}