; ZX Nano Tetris 256bytes VERSION 1.0 (l) Nik@losw.ru 2021
; compile with RASM
;


	BUILDZX
	ORG	0x7D00

$scraddr	equ	0x5800		;0x4000+32*192
$KEYPORT	EQU	0xFE

; rom
$rom_attr1	equ	0x5C8D		;23693 main screen color attr
$rom_attr2	equ	0x5C48		;23624 command line color attr
$rom_prc_clear	equ	0x0D6B		;3435 clear screen system proc

; keyboard
$key5		equ	0xF7		;addres for keys 1-5
$key6		equ	0xEF		;addres fro keys 0-6
$left_k		equ	00010000b	;mask for key '5'

; glass
$linecolor	equ	00110000b	; 0x30
$first_x	equ	9
$width		equ	10		;glass width
$last_y		equ	21		;glass heigh+1

; new figure
$start_x	equ	12		;x-position for new figure

; speed
$start_speed	equ	20		;initial delay for figure fall
;$min_speed	equ	2		;minimal delay for figure fall


main:
// init

	xor	a		; clear screen with standart rom routine
	out	($keyport),a
	ld	($rom_attr1),a
	ld	($rom_attr2),a
	call $rom_prc_clear:

	ld	a,$linecolor	; draw glass sides
	ld	hl,$scraddr+32+$first_x-1
	ld	(hl),a
	ld	($scraddr+32+$first_x-1+$width+1),a
	ld	de,$scraddr+32+$first_x-1+32
	ld	bc,($last_y-1)*32
	ldir

	ld	b,$width+2	; draw glass bottom
loop:	ld	(hl),a
	inc	hl
	djnz loop:

	rra			; set linecolor/2 as initial speed
	ld (_speed),a		; just for matter of code size

loop_main:			; main game loop
	ld	a,r		; a = random number
	and	00000011b	; trunc to 0..3 and switch to 1..4
	inc	a
	rla
	ld	e,a		; 0000nnnS nnn-figure number S - figure state

	ld	bc,1*256+$start_x
	call sprite:		; draw figure on screen
	jr nz,main:

loop_drop:			; dropdown loop
_speed		equ $+1
	ld	d,00		; drop delay

loop_move:			; move loop
	push	bc		; set current state
	push	de
	ld	a,$key6		; read keyblock1
	in	a,($keyport)	; xxxDURxx
	rra
	rra
right:	rra			; if right key pressed
	jr c,up:
	inc	c
up:	rra			; ; if up key pressed
	jr c,down:		
	ld	a,e
	xor	00000001b
	ld	e,a		; switch figure state
	jr next:
down:	rra			; if down key pressed
	jr c,left:
	ld	d,1		; end current drop cycle
left:	ld	a,$key5
	in	a,($keyport)	; read keyblock2
	and	$left_k 	;000L0000
	jr nz,next:
	dec	c

next:	call move:		; move figure
	halt
	halt			; main game delay
	halt
	halt
	dec	d		; decrease drop delay counter
	jr nz,loop_move:	; if =0 then move down 1 step routine

	push	bc
	push	de
	inc	b
	call move:
	ex	af,af'		; if move down sucessful when continue
	jr z,loop_drop:		; else clear filled lines and take new figure

drop:				; clear filled lines routine
module drop
	ld	bc,($last_y-1)*256+$first_x
loop1:	push	bc
	call calc_scraddr:
	push	hl
	xor	a
	ld	c,$width
	cpir			; check if line is filled
	pop	hl
	pop	bc
	jr z,no_line:
	push	bc		; if yes - move upper line down
loop2:	push	bc
	ex	de,hl
	dec	b
	call calc_scraddr:
	push	hl
	ld	c,$width
	ldir
	pop	hl
	pop	bc
	djnz loop2:
	pop	bc
	inc	b
	ld	hl,_speed	; increase game speed by 1 for each cleared line
	dec	(hl)		; by decreasing game delay counter
	jr nz,no_line:
	inc	(hl)
no_line:djnz loop1:
module off

	jr loop_main:

;-----------------------------------------------

calc_scraddr:			; in(b=y(>0) c=x) out(hl=scr_addr)
module	calc_scraddr		; drop()	
	push	de
	ld	hl,$scraddr	; calculate adress for attribute on BC (yx)
	ld	de,32		; position
loop:	add	hl,de
	djnz loop:
	add	hl,bc
	pop	de
	ret
module	off

;-----------------------------------------------

move:
module move2		; in(bc=newYX,de=newFig,stack->curFig,curYX) out(af'=flag)
	exx		;
	pop	hl	; Module for clear prev.sprite and write new one.
	pop	de	; if first phase (clear curFig on curYX and write
	pop	bc	; newFig on newYX) finished unsuccsessfull then
	push	hl	; second phase clear newFig and write currFig back.
	xor	a	;
	ex	af,af'	; Regiserts pages (active and shadow) used for store 
rep:	call sprite:	; current and new state.
	exx		;
	call sprite:	; Shadow af' used for determinate wich phase is running
	or	a	; and for storing final result
	ret z 		;
	ex	af,af'	;
	jr z,rep:	;
	ret		;
module off

;-----------------------------------------------

sprite:
module sprite2		; in(bz=YX,e=Figure num+rotation state) out(a=flag)

	push	bc	; draw figure sprite on screen using xor method
	push	de	; and check if any other sprites is under drawing

	ld	hl,_figures-16*256
	ld	d,16
	sla	e
	add	hl,de
	sla	e

	push	de
	ld	d,(hl)
	inc	hl
	ld	e,(hl)
	call calc_scraddr:
	pop	bc

	ex	de,hl
loop:	add	hl,hl
	jr nc,no_fig:
	ld	a,(de)
	or	a
	jr z,next1:
	inc	l
next1:	xor	c
	ld	(de),a
no_fig:	inc	de
	ld	a,b
	and	0x03
	dec	a
	jr nz,next2:
	ld	a,28
loop1:	inc	de
	dec	a
	jr nz,loop1:
next2:	djnz loop:

	ld	a,h
	or	l
	pop	de
	pop	bc
	ret

module off


;-----------------------------------------------
/*
debug:
module	debug
	push	af,bc,de,hl
	ld	hl,$scraddr+32*10+23
	ld	b,8
loop2:	ld	(hl),00001000b
	rlca
	jr nc,next:
	ld	(hl),00111000b
next:	inc	hl
	djnz	loop2:
	pop	hl,de,bc,af
	ret
module	off
*/

;-----------------------------------------------

// data
_figures equ $-4			; offset for correct calc fignum=(1..4)
	defb	00001111b, 00000000b	;I0
	defb	01000100b, 01000100b	;I1
;	defb	00001111b, 00000000b	;I2
;	defb	01000100b, 01000100b	;I3
;	defb	10001110b, 00000000b	;J0 theres no place in 256b code for
;	defb	01000100b, 11000000b	;J1 figures with 4 states :( 
;	defb	00001110b, 00100000b	;J2
;	defb	01100100b, 01000000b	;J3 
;	defb	00101110b, 00000000b	;L0
;	defb	11000100b, 01000000b	;L1
;	defb	00001110b, 10000000b	;L2
;	defb	01000100b, 01100000b	;L3
	defb	00000110b, 01100000b	;O0
	defb	00000110b, 01100000b	;O1
;	defb	01100110b, 00000000b	;O2
;	defb	01100110b, 00000000b	;O3
	defb	01101100b, 00000000b	;S0
	defb	10001100b, 01000000b	;S1
;	defb	01101100b, 00000000b	;S2
;	defb	10001100b, 01000000b	;S3
;	defb	01001110b, 00000000b	;T0
;	defb	01001100b, 01000000b	;T1
;	defb	00001110b, 01000000b	;T2
;	defb	01000110b, 01000000b	;T3
	defb	11000110b, 00000000b	;Z0
	defb	01001100b, 10000000b	;Z1
;	defb	11000110b, 00000000b	;Z2
;	defb	01001100b, 10000000b	;Z3

