//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
		ld	a,1
		ld	(fade),a
		ret
//======================================================== FX_CONST
buffsz	equ 768
buffa	equ #5800
buffb	equ #5800

//======================================================== FX_INIT
EFF_INI_
	ei
	halt
/*
	ld	a,#17
	call	PAGER

	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
;---
*/

	;--- corr y table
	ld	hl,corr_y
	ld	de,corr_y + 1
	ld	bc,#c0
	ld	(hl),c
	ldir
inicy1
	ld	(hl),l
	inc	l
	jp	nz,inicy1

	call	makepal

	;--- set im2 routine
	ld  hl,fxim2
	ld  (IM2CALL),hl
	ret

makepal
	;--- make palette
	ld	hl,pal1_0
	ld	bc,palette1
	ld	hy,2*6
mkpl0	
	ld	d,h
	ld	e,l
	ld	hx,16
mkpl2
	push	hl
	ld	lx,16
	ld	a,(de)
	and	7
	add a,a:add a,a:add a,a
	ld	ly,a
mkpl1
	ld	a,ly
	or	(hl)
	ld	(bc),a
	inc	c
	inc	hl
	dec	lx
	jp	nz,mkpl1
	pop	hl
	inc	de
	dec	hx
	jp	nz,mkpl2
	ex	de,hl

	inc	b
	dec	hy
	jp	nz,mkpl0

	ret
//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt

	call	bump

	ei
	halt
	call	bump2
	call	movebuff
	call	nextfrm

	ret
//======================================================== FX_PROCEDURES
fxim2
	ld	a,(PAGE)
	xor	#08
	call	PAGER
	and	#08
	ld	a,7
border1 equ $-1
	jr	z,1f
	ld	a,7
border2 equ $-1
1	out	(#fe),a
	jp  IM2CALL_RET
;----------------------------------
nextfrm
	ld	h,cos_x / 256
	ld	a,0
ddx	equ $-1
	add	a,3
	ld	(ddx),a
	ld	l,a
	ld	a,(hl)
	sub	64+8
	ld	(light_pos_y),a

	ld	h,cos_y / 256
	ld	a,0
ddy	equ $-1
	add	a,4
	ld	(ddy),a
	ld	l,a
	ld	a,(hl)
	sub	20
	ld	(light_pos_x),a
	
	ld	a,0
fade	equ $-1
	or	a
	ret	z

	ld	a,1
fadew	equ $-1
	dec	a
	and	1
	ld	(fadew),a
	ret	nz

	ld	a,5
fadea	equ $-1
	sub	1
	ret	c
	ld	(fadea),a
	
	ld	a,(paladr1)
	inc	a
	inc	a
	ld	(paladr1),a
	inc	a
	ld	(paladr2),a
	
	ret

;----------------------------------
movebuff

	ld	a,(PAGE)
	or	7
	call	PAGER

	ld	h,palette1/256
paladr1	equ $-1
	ld	de,#5800
	exx
	ld	h,palette2/256
paladr2	equ $-1
	ld	de,#d800

	ld	a,(PAGE)
	and	#08
	jr	z,mvbf2
	exx
mvbf2	;--
	call	mvbf0
	exx
	call	mvbf0
	
	ld	l,0
	ld	a,(paladr1)
	ld	h,a
	ld	a,(hl)
	and	7
	ld	(border1),a
	ld	a,(paladr2)
	ld	h,a
	ld	a,(hl)
	and	7
	ld	(border2),a
	ret
	
mvbf0	ld	(sohr_sp2),sp
	ld	sp,buff
	ld	lx,12
mvbf1	;--
	dup	32
	pop	bc	;10
	ld	l,c	;4
	ld	a,(hl)
	ld	(de),a
	inc	e
	ld	l,b	;4
	;ld	a,(hl)
	;ld	(de),a
	;inc	e
	ldi
	edup
	;org $-1
	;inc	de
	;--
	dec	lx
	jp	nz,mvbf1
	;-----
	ld	sp,0
sohr_sp2 equ $-2
	ret

;----------------------------------

bump2
	ld	hl,bumpdata+32*17*5
	ld	de,buff+32*17
	ld	c,7	;24-17-2
	jp	bump0
bump

	ld	hl,bumpdata
	ld	de,buff
	ld	c,17

bump0	
	push	bc
	ld	a,(PAGE)
	and	%11111000
	call	PAGER
	pop	bc
	;---
	ld	(sohrsp),sp
	ld	sp,hl
	exx
	ld	bc,0
light_pos_y equ $-1
light_pos_x equ $-2
	ld	d,corr_y/256
	exx
	
bumplp	exx
	;----
	dup	16
	;------------------
	pop	hl	;10
	add	hl,bc	;11
	ld	e,h	;4
	ld	a,(de)	;7
	ld	h,a	;4
	ld	a,(hl)	;7
	ex	af,af	;4 /47
	;--
	pop	hl	;10
	add	hl,bc	;11
	ld	e,h	;4
	ld	a,(de)	;7
	ld	h,a	;4
	ex	af,af	;4
	or	(hl)	;7 /47
	;--
	exx		;4
	pop	hl	;10
	add	a,l	;4
	ld	(de),a	;7
	inc	e	;4
	exx		;4
	;------------------
	pop	hl	;10
	add	hl,bc	;11
	ld	e,h	;4
	ld	a,(de)	;7
	ld	h,a	;4
	ld	a,(hl)	;7
	ex	af,af	;4 /47
	;--
	pop	hl	;10
	add	hl,bc	;11
	ld	e,h	;4
	ld	a,(de)	;7
	ld	h,a	;4
	ex	af,af	;4
	or	(hl)	;7 /47
	;--
	exx		;4
	add	a,h	;4
	ld	(de),a	;7
	inc	e	;4
	exx		;4
	;------------------
	edup
	;----
	org	$-2
	inc	de
	dec	c
	jp	nz,bumplp
	;----
	ld	sp,0
sohrsp	equ $-2
	ret

//======================================================== FX_INCLUDE_DATA

;pal1_0	db	#00, #00, #00, #00, #00, #00, #00, #00, #00, #02, #02, #42, #42, #42, #07, #00
;pal2_0	db	#00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #02, #02, #06, #47, #47, #00


pal1_0	DB	#00, #03, #01, #02, #06, #07, #00, #00, #00, #02, #00, #02, #06, #02, #07, #00
pal2_0	DB	#00, #00, #42, #43, #42, #42, #00, #00, #00, #00, #42, #42, #42, #47, #47, #00

pal1_1	db	#00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #42, #42, #43, #43, #43, #00
pal2_1	db	#02, #02, #02, #02, #02, #02, #02, #02, #02, #03, #03, #03, #43, #07, #47, #02
pal1_2	db	#00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #03, #03, #03, #43, #43, #00
pal2_2	db	#03, #03, #03, #03, #03, #03, #03, #03, #03, #43, #43, #43, #43, #43, #07, #03
pal1_3	db	#00, #00, #00, #00, #00, #00, #00, #00, #00, #03, #03, #03, #03, #03, #43, #00
pal2_3	db	#43, #43, #43, #43, #43, #43, #43, #43, #43, #03, #03, #03, #43, #43, #43, #43
pal1_4	db	#03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03
pal2_4	db	#03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #43, #03
pal1_5	db	#03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03
pal2_5	db	#03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03, #03

	align 256
cos_x	include "bin/cos-x.asm"
cos_y	include "bin/cos-y.asm"

corr_y		equ $ + 256
palette1	equ corr_y + 256*1
palette2	equ corr_y + 256*2
palette1_1	equ corr_y + 256*3
palette2_1	equ corr_y + 256*4
palette1_2	equ corr_y + 256*5
palette2_2	equ corr_y + 256*6
palette1_3	equ corr_y + 256*7
palette2_3	equ corr_y + 256*8
palette1_4	equ corr_y + 256*9
palette2_4	equ corr_y + 256*10
palette1_5	equ corr_y + 256*11
palette2_5	equ corr_y + 256*12


buff		equ corr_y + 256*13
bumpdata	equ buff + 768

	;org	bumpdata
	;include "bin/bump_texture_1.asm"

	display "bumpdata: ", /A, bumpdata
	display "border1: ", /A, border1
	display "border2: ", /A, border2
	