//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
		jp	setrotout
//======================================================== FX_CONST
stepMax	equ 280
grviewlen equ 18; //18*4
grhidelen equ 8;8

grviewlen2 equ 36
grhidelen2 equ 8
//======================================================== FX_INIT
EFF_INI_
	ei
	halt

;-- debug
	ld	a,#17
	call	PAGER

	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
;-- debug

	call	makepal

	ld	hl,buff
	ld	de,buff+1
	ld	(hl),#bb
	ld	bc,767
	ldir

	;--- set im2 routine
	ld  hl,fxim2
	ld  (IM2CALL),hl

	ret

makepal
	;--- makepal
	ld	bc,pal
	ld	hy,8
mkpl2	push	bc
	ld	hl,pal1
	call	mkpl0

	pop	bc
	inc	b
	push	bc	
	ld	hl,pal2
	call	mkpl0

	call	mkplmv

	pop	bc
	inc	b

	dec	hy
	jp	nz,mkpl2
	ret

mkpl0	push	hl
	pop	ix
	ld	de,16
	add	hl,de
	;---
	ld	ly,16
mkpl1	;--
	ld	d,hx
	ld	e,lx
	;--
	dup	16
	ld	a,(de)
	or	(hl)
	ld	(bc),a
	inc	de
	inc	bc
	edup
	;--
	inc	hl
	;--
	dec	ly
	jp	nz,mkpl1
	;--
	ret
mkplmv
	ld	hl,pal1
	call	mkplmv1
	ld	hl,pal1+16
	call	mkplmv1
	ld	hl,pal2
	call	mkplmv1
	ld	hl,pal2+16
mkplmv1
	ld	a,(hl)
	ld	d,h
	ld	e,l
	inc	hl
	dup	7
	ldi
	edup
	ld	(de),a
	ret
//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt

	ld	a,7
border2	equ $-1
	ld	(border),a
	out	(#fe),a


	if SHOW_FRAMES = 1
	  ;ld	a,(FRAMES_QTY)
	  ;out	(#fe),a
	  ;xor	a
	  ;ld	(FRAMES_QTY),a
	endif

	call	movebuff
	call	nextfrm
	call	rotozoom
	call	greetz

	if SHOW_FRAMES = 1
          xor a:out (#fe),a
	endif
	
	xor	a
	ld	(border3),a
	

	RET
//======================================================== FX_PROCEDURES

setrotout
	ld	a,grhidelen2
	ld	(grhidelen_adr),a
	ld	a,grviewlen2
	ld	(grviewlen_adr1),a
	ld	(grviewlen_adr2),a
	ld	hl,word_tbl2
	ld	(greetzhl),hl

	ld	hl,zxdata_end - 8
	ld	(zxdata_adr),hl
	ld	hl,0 - 8
	ld	(zxdata_step),hl
	ld	hl,zxdata_end
	ld	(zxdata_adr2),hl
	ld	a,-1
	ld	(palmv_dir),a
	ret


fxim2
	ld	a,0
border	equ	$-1
	out	(#fe),a

	ld  a,(PAGE)
	xor #08
	call PAGER
	jp  IM2CALL_RET

;-------------------------
nextfrm
	ld	hl,zxdata
zxdata_adr equ $-2
	; x0, y0, stepX, stepY
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	(x0),de
	;--
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	(y0),de
	;--
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	(stepX),de

	scf
	bit	7,d
	jr	nz,1f
	and	a
1	rr	d
	rr	e

	ld	(dy1y),de
	ld	(dy2y),de
	
	;--
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	(stepY),de

	scf
	bit	7,d
	jr	nz,1f
	and	a
1	rr	d
	rr	e

	ld	(dy1x),de
	ld	(dy2x),de

	;--
	ld	bc,stepMax
step equ $-2
	dec	bc
	ld	a,b
	or	c
	ld	hl,(zxdata_adr)
	jr	nz,nostep
	;-
	ld	hl,zxdata-8
zxdata_adr2 equ $-2
	ld	bc,stepMax
	
	;-
nostep	ld	(step),bc
	ld	de,8
zxdata_step equ $-2
	add	hl,de
	ld	(zxdata_adr),hl

	ld	a,15
palmvcnt equ $-1
	dec	a
	ld	(palmvcnt),a
	ret	nz
	
	ld	a,14
	ld	(palmvcnt),a
	
	ld	a,(palmv)
	add	a,1
palmv_dir equ $-1
	and	7
	ld	(palmv),a
	
	ret
;-----------------------------
movebuff

	ld	a,0
border3	equ $-1
	ld	(border2),a
	ld	(border),a

	ld	a,(PAGE)
	or	7
	call	PAGER

	ld	a,0
palmv	equ $-1
	add	a,a
	add	a,pal / 256

	ld	h,a
	ld	de,#5800
	exx
	inc	a
	ld	h,a
	ld	de,#d800

	ld	a,(PAGE)
	and	#08
	jr	nz,1f
	exx
1


	call	mvbf0
	exx

mvbf0	ld	(sohr_sp1),sp
	ld	sp,buff
	ld	a,12
mvbf1	;--
	dup	32
	pop	bc	;10
	ld	l,c	;4
	ldi		;16
	ld	l,b	;4
	ldi		;16 /50
	edup
	;--
	dec	a
	jp	nz,mvbf1
	;-----
	ld	sp,0
sohr_sp1 equ $-2
	ret
;-----------------------
rotozoom
	ld	a,(PAGE)
	and	%11111000
	call    PAGER

	;-----		;pri
	ld	hl,0
y0 equ $-2
	ld	bc,0
stepY equ $-2
	ld	de,buff
	;---
	exx		;alt
	ld	hl,0
x0 equ $-2
	ld	bc,0
stepX equ $-2
	;--------------
	ld	ly,24
	;-------------- alt
lp1	push	hl
	exx		;pri
	push	hl
	;--------------
	push	de
	;--------------
	dup	32
	;---
	add	hl,bc	;11
	ld	a,h	;4
	exx		;4	;alt
	add	hl,bc	;11
	ld	d,a	;4
	ld	e,h	;4
	ld	a,(de)	;7
	exx		;4	;pri
	ld	(de),a	;7
	inc	e	;4 /60
	;---
	edup
	;---
	org $-1
	pop	de
	;--------------
	pop	hl	;10
	push	bc	;11
	ld	bc,0	;10
dy1y equ $-2
	add	hl,bc	;11
	pop	bc	;10
	exx		;4	;alt
	pop	hl	;10
	ld	de,0	;10
dy1x equ $-2
	sbc	hl,de	;15
	push	hl	;11
	set	7,h	;8
	exx		;4	;pri
	push	hl	;11 /125
	;--------------
	push hl:pop ix:ex de,hl
	;--------------
	dup	32
	;---
	add	ix,bc	;15
	exx		;4	;alt
	add	hl,bc	;11
	ld	d,hx	;8
	ld	e,h	;4
	ld	a,(de)	;7
	exx		;4	;pri
	or	(hl)	;7
	ld	(hl),a	;7
	inc	l	;4 /71
	;---
	edup
	;--------------
	org $-1
	inc	hl
	ex	de,hl
	;--------------
	pop	hl
	push	bc
	ld	bc,0
dy2y equ $-2
	add	hl,bc
	pop	bc
	exx			;alt
	pop	hl
	ld	de,0
dy2x equ $-2
	sbc	hl,de
	;--------------
	dec	ly
	jp	nz,lp1
	ret
;-------------------------------------
greetz
	ld	hl,word_tbl
greetzhl equ $-2
	ld	a,(hl)
	or	a
	ret	z
	
	ld	ly,a
	inc	hl
grlp1
	ld	a,(hl)
	inc	hl
	ld	hx,a
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl

	push	hl
	push	bc
	pop	hl

	ld	a,grviewlen
grviewlen_adr1 equ $-1
greetza	equ	$-1
	cp	grhidelen
grhidelen_adr equ $-1
	push	af
	call	nc,greetz1
	pop	af
	pop	hl

	dec	ly
	jp	nz,grlp1

	ld	a,(greetza)
	sub	1
	adc	a,0
	ld	(greetza),a
	;or	a
	;ret	nz

	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	push	hl
	ld	hl,(MUSPOS)
	and	a
	sbc	hl,bc
	pop	hl
	
	ret	c

	ld	a,grviewlen
grviewlen_adr2 equ $-1
2	ld	(greetza),a
	ld	(greetzhl),hl
	ret


greetz1
	ld	lx,#03
splp2	
	ld	b,hx
	push	hl
splp1	
	ld	a,(de)
	or	a
	jr	z,$+3
	ld	(hl),a
	inc	l
	inc	de
	djnz	splp1
	;-
	pop	hl
	ld	bc,32
	add	hl,bc
	;-
	dec	lx
	jp	nz,splp2
	;---
	ret
	include "bin/texts.asm"


//======================================================== FX_INCLUDE_DATA
zxdata	include "bin/zxdata.asm"
zxdata_end

sprr
	;db	#99,#98,#98, #00, #99,#98,#98, #00, #99,#98,#98, #00, #99,#98,#98, #00, #98,#99,#98, #00, #98,#98,#99
	;db	#aa,#00,#aa, #00, #aa,#00,#00, #00, #aa,#a8,#00, #00, #aa,#a8,#00, #00, #00,#aa,#00, #00, #aa,#a8,#a8
	;db	#b8,#b8,#b8, #00, #b8,#00,#00, #00, #b8,#b8,#b8, #00, #b8,#b8,#b8, #00, #00,#b8,#00, #00, #b8,#b8,#b8
	;db	#00,#00,#00, #00, #00,#00,#00, #00, #00,#00,#00, #00, #00,#00,#00, #00, #00,#00,#00, #00, #00,#00,#00

pal1	DB	#00+1*3,#00+1*7,#00+1*6,#00+1*2,#00+1*6,#00+1*3,#00+1*7,#00+1*4
	db	#00+1*0,#40+1*7,#00+1*7,#00+1*7
	ds	4,0
	DB	#00+8*3,#00+8*7,#00+8*6,#00+8*2,#00+8*6,#00+8*3,#00+8*7,#00+8*4
	db	#00+8*0,#40+8*7,#00+8*7,#00+8*7
	ds	4,0
	
pal2	DB	#00+1*5,#00+1*7,#00+1*2,#00+1*2,#00+1*6,#00+1*4,#00+1*7,#00+1*7
	db	#00+1*0,#40+1*7,#40+1*7,#00+1*7
	ds	4,0
	DB	#00+8*5,#00+8*7,#00+8*2,#00+8*2,#00+8*6,#00+8*4,#00+8*7,#00+8*7
	db	#00+8*0,#40+8*7,#40+8*7,#00+8*7
	ds	4,0	

pal	equ ($/256+1)*256
buff	equ pal + 256*16

EFF_USE_END equ buff + 768

	display "EFF_USE_END: ", /A, EFF_USE_END

