/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000b\u001a!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002\u001a \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a&\u0010\u000b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a?\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0001\"\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0002\u001a\u0006\u0010 \u001a\u00020\u0014\u001a\u000e\u0010!\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002\u001a&\u0010$\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0010\u001a,\u0010$\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000f\u00a8\u0006("}, d2={"encodeMpag", "", "", "magazine", "y", "(II)[Ljava/lang/Integer;", "extractGraphicRegions", "LFrameRegions;", "buf", "", "color", "formatAsPage", "source", "pageNumber", "textLines", "", "", "ham", "d", "insertPageHeader", "", "pos", "subPage", "flags", "LPageHeaderControlBit;", "([BIII[LPageHeaderControlBit;)V", "isColorSetter", "", "ch", "", "isGraphicData", "char", "main", "parity", "unham", "b", "writeIntoBuffer", "x", "s", "bytes", "teletext-tools"})
public final class BuffersAndEncodingKt {
    public static final void insertPageHeader(@NotNull byte[] buf, int pos, int pageNumber, int subPage, PageHeaderControlBit ... flags) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(flags, "flags");
        int pageDigit1 = (pageNumber & 0xF00) >> 8;
        int pageDigit2 = (pageNumber & 0xF0) >> 4;
        int pageDigit3 = pageNumber & 0xF;
        int magazine = pageDigit1;
        Integer[] mpag = BuffersAndEncodingKt.encodeMpag(magazine, 0);
        buf[pos + 0] = (byte)mpag[0].intValue();
        buf[pos + 1] = (byte)mpag[1].intValue();
        buf[pos + 2] = (byte)BuffersAndEncodingKt.ham(pageDigit3);
        buf[pos + 3] = (byte)BuffersAndEncodingKt.ham(pageDigit2);
        int s1 = subPage & 0xF;
        int s2 = (subPage & 0x70) >> 4;
        int s3 = (subPage & 0xF00) >> 8;
        int s4 = (subPage & 0x3000) >> 12;
        int ctrl1 = 0;
        int ctrl2 = 0;
        if (ArraysKt.contains(flags, PageHeaderControlBit.C4_ERASE_PAGE)) {
            s2 |= 8;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C5_NEWSFLASH)) {
            s4 |= 4;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C6_SUBTITLE)) {
            s4 |= 8;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C7_SUPPRESS_HEADER)) {
            ctrl1 |= 1;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C8_UPDATE_INDICATOR)) {
            ctrl1 |= 2;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C9_INTERRUPTED_SEQUENCE)) {
            ctrl1 |= 4;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C10_INHIBIT_DISPLAY)) {
            ctrl1 |= 8;
        }
        if (ArraysKt.contains(flags, PageHeaderControlBit.C11_MAGAZINE_SERIAL)) {
            ctrl2 |= 1;
        }
        buf[pos + 4] = (byte)BuffersAndEncodingKt.ham(s1);
        buf[pos + 5] = (byte)BuffersAndEncodingKt.ham(s2);
        buf[pos + 6] = (byte)BuffersAndEncodingKt.ham(s3);
        buf[pos + 7] = (byte)BuffersAndEncodingKt.ham(s4);
        buf[pos + 8] = (byte)BuffersAndEncodingKt.ham(ctrl1);
        buf[pos + 9] = (byte)BuffersAndEncodingKt.ham(ctrl2);
    }

    @NotNull
    public static final byte[] formatAsPage(@NotNull byte[] source, int pageNumber, @NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(buf, "buf");
        int pageDigit1 = (pageNumber & 0xF00) >> 8;
        int pageDigit2 = (pageNumber & 0xF0) >> 4;
        int pageDigit3 = pageNumber & 0xF;
        int magazine = pageDigit1;
        int sourcePos = 0;
        for (int y = 0; y < 24; ++y) {
            int rawLineStart = 42 * y;
            Integer[] mpag = BuffersAndEncodingKt.encodeMpag(magazine, y);
            buf[rawLineStart + 0] = (byte)mpag[0].intValue();
            buf[rawLineStart + 1] = (byte)mpag[1].intValue();
            for (int i = 0; i < 40; ++i) {
                buf[rawLineStart + 2 + i] = (byte)BuffersAndEncodingKt.parity(source[sourcePos++]);
            }
            if (y != 0) continue;
            buf[rawLineStart + 2] = (byte)BuffersAndEncodingKt.ham(pageDigit3);
            buf[rawLineStart + 3] = (byte)BuffersAndEncodingKt.ham(pageDigit2);
            buf[rawLineStart + 4] = 21;
            buf[rawLineStart + 5] = 21;
            buf[rawLineStart + 6] = 21;
            buf[rawLineStart + 7] = 21;
            buf[rawLineStart + 8] = 21;
            buf[rawLineStart + 9] = 21;
        }
        return buf;
    }

    public static /* synthetic */ byte[] formatAsPage$default(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            int n3 = 0;
            byte[] byArray3 = new byte[1008];
            while (n3 < 1008) {
                int n4 = n3++;
                byArray3[n4] = 32;
            }
            byArray2 = byArray3;
        }
        return BuffersAndEncodingKt.formatAsPage(byArray, n, byArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] formatAsPage(@NotNull List<String> textLines, int pageNumber, @NotNull byte[] buf) {
        Intrinsics.checkNotNullParameter(textLines, "textLines");
        Intrinsics.checkNotNullParameter(buf, "buf");
        int pageDigit1 = (pageNumber & 0xF00) >> 8;
        int pageDigit2 = (pageNumber & 0xF0) >> 4;
        int pageDigit3 = pageNumber & 0xF;
        int magazine = pageDigit1;
        int n = textLines.size();
        for (int y = 0; y < n; ++y) {
            void $this$forEachIndexed$iv;
            int rawLineStart = 42 * y;
            Integer[] mpag = BuffersAndEncodingKt.encodeMpag(magazine, y);
            buf[rawLineStart + 0] = (byte)mpag[0].intValue();
            buf[rawLineStart + 1] = (byte)mpag[1].intValue();
            Intrinsics.checkNotNullExpressionValue(textLines.get(y).toCharArray(), "this as java.lang.String).toCharArray()");
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (void item$iv : $this$forEachIndexed$iv) {
                void ch;
                int n2 = index$iv++;
                void var17_17 = item$iv;
                int i = n2;
                boolean bl = false;
                buf[rawLineStart + 2 + i] = (byte)BuffersAndEncodingKt.parity((int)ch);
            }
            if (y != 0) continue;
            buf[rawLineStart + 2] = (byte)BuffersAndEncodingKt.ham(pageDigit3);
            buf[rawLineStart + 3] = (byte)BuffersAndEncodingKt.ham(pageDigit2);
            buf[rawLineStart + 4] = 21;
            buf[rawLineStart + 5] = 21;
            buf[rawLineStart + 6] = 21;
            buf[rawLineStart + 7] = 21;
            buf[rawLineStart + 8] = 21;
            buf[rawLineStart + 9] = 21;
        }
        return buf;
    }

    public static /* synthetic */ byte[] formatAsPage$default(List list, int n, byte[] byArray, int n2, Object object) {
        if ((n2 & 4) != 0) {
            int n3 = 0;
            byte[] byArray2 = new byte[1008];
            while (n3 < 1008) {
                int n4 = n3++;
                byArray2[n4] = 32;
            }
            byArray = byArray2;
        }
        return BuffersAndEncodingKt.formatAsPage(list, n, byArray);
    }

    @NotNull
    public static final Integer[] encodeMpag(int magazine, int y) {
        int byteValue = magazine | y << 3;
        int nibble1 = byteValue & 0xF;
        int nibble2 = (byteValue & 0xF0) >> 4;
        Integer[] integerArray = new Integer[]{BuffersAndEncodingKt.ham(nibble1), BuffersAndEncodingKt.ham(nibble2)};
        return integerArray;
    }

    public static final int unham(int b) {
        int d1 = (b & 2) == 0 ? 0 : 1;
        int d2 = (b & 8) == 0 ? 0 : 2;
        int d3 = (b & 0x20) == 0 ? 0 : 4;
        int d4 = (b & 0x80) == 0 ? 0 : 8;
        return d1 | d2 | d3 | d4;
    }

    public static final int ham(int d) {
        int d1 = d & 1;
        int d2 = d >> 1 & 1;
        int d3 = d >> 2 & 1;
        int d4 = d >> 3 & 1;
        int p1 = 1 + d1 + d3 + d4 & 1;
        int p2 = 1 + d1 + d2 + d4 & 1;
        int p3 = 1 + d1 + d2 + d3 & 1;
        int p4 = 1 + p1 + d1 + p2 + d2 + p3 + d3 + d4 & 1;
        return p1 | d1 << 1 | p2 << 2 | d2 << 3 | p3 << 4 | d3 << 5 | p4 << 6 | d4 << 7;
    }

    public static final int parity(int d) {
        int d2 = d;
        int p = 1;
        int t = d2 &= 0x7F;
        int i = 0;
        for (i = 0; i < 7; ++i) {
            p += t & 1;
            t >>= 1;
        }
        return d2 | (p &= 1) << 7;
    }

    public static final void writeIntoBuffer(@NotNull byte[] buf, int x, int y, @NotNull String s) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(s, "s");
        BuffersAndEncodingKt.writeIntoBuffer(buf, x, y, ArraysKt.asList(StringsKt.encodeToByteArray(s)));
    }

    public static final void writeIntoBuffer(@NotNull byte[] buf, int x, int y, @NotNull List<Byte> bytes) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        boolean raw = buf.length % 42 == 0;
        int stride = raw ? 42 : 40;
        int off = raw ? 2 : 0;
        int pos = y * stride + x + off;
        Iterator<Byte> iterator2 = bytes.iterator();
        while (iterator2.hasNext()) {
            byte element = ((Number)iterator2.next()).byteValue();
            buf[pos++] = (byte)BuffersAndEncodingKt.parity(element);
        }
    }

    @NotNull
    public static final FrameRegions extractGraphicRegions(@NotNull byte[] buf, int color) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        FrameRegions ret = new FrameRegions(null, 1, null);
        for (int y = 1; y < 24; ++y) {
            LineRegion current = null;
            for (int x = 0; x < 40; ++x) {
                int n = buf[y * 40 + x] & 0x7F;
                if (current != null) {
                    if (BuffersAndEncodingKt.isGraphicData(n)) {
                        current.getCols().add(x);
                        continue;
                    }
                    if (!current.getCols().isEmpty()) {
                        ret.getLineRegions().add(current);
                    }
                    current = null;
                    continue;
                }
                if (n != (0x10 | color)) continue;
                current = new LineRegion(y, null, 2, null);
            }
            if (current == null) continue;
            ret.getLineRegions().add(current);
        }
        return ret;
    }

    public static final boolean isGraphicData(int n) {
        return (n & 0x7F) >= 32;
    }

    public static final boolean isGraphicData(byte by) {
        return BuffersAndEncodingKt.isGraphicData((int)by);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isColorSetter(byte ch) {
        boolean bl;
        byte by = (byte)(ch & 0x7F);
        if (0 <= by) {
            if (by < 8) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        by = (byte)(ch & 0x7F);
        if (16 > by) return false;
        if (by >= 24) return false;
        return true;
    }

    public static final void main() {
        byte[] seite = FilesKt.readBytes(new File("gfx/talk/teletext-seite.bin"));
        int y = 6;
        while (true) {
            int i = y - 6;
            seite[y * 40 + 15] = (byte)(32 + i);
            seite[y * 40 + 16] = (byte)(48 + i);
            seite[y * 40 + 17] = (byte)(64 + i);
            seite[y * 40 + 18] = (byte)(80 + i);
            seite[y * 40 + 19] = (byte)(96 + i);
            seite[y * 40 + 20] = (byte)(112 + i);
            seite[y * 40 + 21] = 23;
            seite[y * 40 + 22] = (byte)(32 + i);
            seite[y * 40 + 23] = (byte)(48 + i);
            seite[y * 40 + 24] = (byte)(96 + i);
            seite[y * 40 + 25] = (byte)(112 + i);
            if (y == 22) break;
            ++y;
        }
        Files.write(new File("gfx/talk/teletext-seite0.bin").toPath(), seite, new OpenOption[0]);
        for (int i = 0; i < 16; ++i) {
            int ham = BuffersAndEncodingKt.ham(i);
            int par = BuffersAndEncodingKt.parity(i);
            String string = "%2d %s %s %s";
            Object[] objectArray = new Object[]{i, GlobalsKt.binformat(i, 8), GlobalsKt.binformat(par, 8), GlobalsKt.binformat(ham, 8)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            string = string2;
            System.out.println((Object)string);
        }
    }

    public static /* synthetic */ void main(String[] args2) {
        BuffersAndEncodingKt.main();
    }
}

